var samplePageObj = {
  externalScript: ['../assets/ibsheet/plugins/ibsheet-excel.js'],

  // 샘플 타이틀
  title: '트리 사용',
  subtitle: '시트 내에 특정 컬럼을 트리로 만들어 사용하실 수 있습니다.',
  // 샘플 설명
  desc: '트리를 사용하는 시트는 트리의 모양이나 부모/자식 관계에 따른 다양한 API를 사용하실 수 있습니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      MainCol: 'Cls',
      Export: { Url: (location.href.indexOf('localhost') > -1 ? '../jsp/' : 'https://api.ibleaders.com/ibsheet/v8/') }
    },
    LeftCols: [
      {
        Type: 'Int',
        Width: 60,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: '생산자물가지수',
        Type: 'Text',
        Name: 'Cls',
        MinWidth: '200',
        Align: 'Left',
        RelWidth: 1,
        CanEdit: 1
      },
      {
        Header: '2012년 8월',
        Type: 'Float',
        Name: 'Y201208',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2012년 9월',
        Type: 'Float',
        Name: 'Y201209',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2012년 10월',
        Type: 'Float',
        Name: 'Y201210',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2012년 11월',
        Type: 'Float',
        Name: 'Y201211',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2012년 12월',
        Type: 'Float',
        Name: 'Y201212',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 1월',
        Type: 'Float',
        Name: 'Y201301',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 2월',
        Type: 'Float',
        Name: 'Y201302',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 3월',
        Type: 'Float',
        Name: 'Y201303',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 4월',
        Type: 'Float',
        Name: 'Y201304',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 5월',
        Type: 'Float',
        Name: 'Y201305',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 6월',
        Type: 'Float',
        Name: 'Y201306',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 7월',
        Type: 'Float',
        Name: 'Y201307',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
      {
        Header: '2013년 8월',
        Type: 'Float',
        Name: 'Y201308',
        Width: '100',
        Align: 'Right',
        Format: '#,##0.00',
        FormulaRow: 'Sum',
        CanEdit: 1
      },
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div> <label>포커스 된 행 기준으로</label> <select id=\'inpAbove\' class=\'mgr10\'><option value=\'1\'>위로</option><option value=\'0\'>아래로</option></select> <select class=\'mgr10\' id=\'inpLvl\'><option value=\'1\'>같은 레벨로</option><option value=\'0\'>자식 레벨로</option></select> <button class=\'mgr10\' onclick=\'sampleBtn(this)\'>행추가</button></div>'
            + '<div><button class=\'mgr10\' onclick=\'sampleBtn(this)\'>모두접기</button> <button class=\'mgr10\' onclick=\'sampleBtn(this)\'>모두펼침</button> <select id=\'level\' class=\'mgr10\'><option value=\'1\'>1</option><option value=\'2\'>2</option><option selected value=\'3\'>3</option><option value=\'4\'>4</option><option value=\'5\'>5</option><option value=\'6\'>6</option></select> <button class=\'mgr10\' onclick=\'sampleBtn(this)\'>레벨까지 보기</button> <button class=\'mgr10\' onclick=\'sampleBtn(this)\'>노드연결선 감추기</button></div>'
            + '<div><button class=\'mgr10\' onclick=\'sampleBtn(this)\'>엑셀다운로드</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    var nextRow;
    var parentRow;
    var above = ~~(document.getElementById('inpAbove').value);
    var lvl = ~~(document.getElementById('inpLvl').value);

    if (arguments[0].innerText === '행추가') {
      if (above) { // 포커스된 행 위로 추가
        if (lvl) { // 포커스된 행과 같은 레벨로 추가
          nextRow = sheet.getFocusedRow();
          if (!nextRow) {
            sheet.showMessageTime({
              message: '포커스를 해주세요',
              time: 1200
            });

            return;
          }
          parentRow = sheet.getFocusedRow().parentNode;
        } else { // 포커스된 행의 자식레벨로 추가
          sheet.showMessageTime({
            message: '자식노드는 포커스된 행의 아래로만 추가하실 수 있습니다.',
            time: 1200
          });

          return;
        }
      } else { // 포커스된 행 아래로 추가
        var focusRow = sheet.getFocusedRow();

        if (!focusRow) {
          sheet.showMessageTime({
            message: '포커스를 해주세요',
            time: 1200
          });

          return;
        }

        if (lvl) { // 포커스된 행과 같은 레벨로 추가
          nextRow = sheet.getNextSiblingRow(focusRow);
          parentRow = focusRow.parentNode;
        } else { // 포커스된 행의 자식레벨로 추가
          parentRow = focusRow;
        }
      }
      sheet.addRow({
        next: nextRow,
        visible: 1,
        parent: parentRow
      });
    } else if (arguments[0].innerText === '엑셀다운로드') {
      sheet.down2Excel({
        FileName: 'Tree형식 IBSheet.xlsx',
        SheetDesign: 1,
        Merge: 1
      });
    } else if (arguments[0].innerText === '모두접기') {
      sheet.showTreeLevel(1, null, 1);
    } else if (arguments[0].innerText === '모두펼침') {
      sheet.showTreeLevel(10, null, 2);
    } else if (arguments[0].innerText === '레벨까지 보기') {
      lvl = document.getElementById('level').value;

      sheet.showTreeLevel(lvl);
    } else if (arguments[0].innerText === '노드연결선 감추기') {
      sheet.NoTreeLines = 1;
      sheet.rerender();
      arguments[0].innerText = '노드연결선 표시하기';
    } else if (arguments[0].innerText === '노드연결선 표시하기') {
      sheet.NoTreeLines = 0;
      sheet.rerender();
      arguments[0].innerText = '노드연결선 감추기';
    }
  },

  // event구문
  event: {
    onBeforeExpand: function (evtParam) {
      console.log(evtParam.eventName + ':' + evtParam.row.HasIndex);
    }
  },

  // data
  data: [
    {
      Cls: '총지수',
      Y201208: 107.24,
      Y201209: 107.62,
      Y201210: 106.78,
      Y201211: 106.05,
      Y201212: 105.78,
      Y201301: 105.95,
      Y201302: 106.68,
      Y201303: 106.26,
      Y201304: 105.92,
      Y201305: 105.56,
      Y201306: 105.54,
      Y201307: 105.52,
      Y201308: 105.81,
      Items: [
        {
          Cls: '상품',
          Y201208: 108.56,
          Y201209: 109.17,
          Y201210: 107.84,
          Y201211: 106.77,
          Y201212: 106.40,
          Y201301: 106.76,
          Y201302: 107.75,
          Y201303: 107.08,
          Y201304: 106.61,
          Y201305: 106.05,
          Y201306: 106.03,
          Y201307: 105.92,
          Y201308: 106.27,
          Items: [
            {
              Cls: '농림수산품',
              Y201208: 110.23,
              Y201209: 112.52,
              Y201210: 104.74,
              Y201211: 100.45,
              Y201212: 103.13,
              Y201301: 105.48,
              Y201302: 107.53,
              Y201303: 103.66,
              Y201304: 103.27,
              Y201305: 100.36,
              Y201306: 99.14,
              Y201307: 99.81,
              Y201308: 105.19,
              Items: [
                {
                  Cls: '농림수산품',
                  Y201208: 110.23,
                  Y201209: 112.52,
                  Y201210: 104.74,
                  Y201211: 100.45,
                  Y201212: 103.13,
                  Y201301: 105.48,
                  Y201302: 107.53,
                  Y201303: 103.66,
                  Y201304: 103.27,
                  Y201305: 100.36,
                  Y201306: 99.14,
                  Y201307: 99.81,
                  Y201308: 105.19,
                  Items: [
                    {
                      Cls: '농산물',
                      Y201208: 121.01,
                      Y201209: 127.95,
                      Y201210: 117.55,
                      Y201211: 107.34,
                      Y201212: 113.00,
                      Y201301: 118.80,
                      Y201302: 122.67,
                      Y201303: 114.81,
                      Y201304: 111.81,
                      Y201305: 105.61,
                      Y201306: 102.10,
                      Y201307: 103.12,
                      Y201308: 112.19,
                      Items: [
                        {
                          Cls: '식량작물',
                          Y201208: 126.05,
                          Y201209: 125.90,
                          Y201210: 124.39,
                          Y201211: 129.98,
                          Y201212: 130.63,
                          Y201301: 131.05,
                          Y201302: 131.65,
                          Y201303: 131.00,
                          Y201304: 130.21,
                          Y201305: 130.68,
                          Y201306: 131.27,
                          Y201307: 131.05,
                          Y201308: 132.30,
                          Items: [
                            {
                              Cls: '곡류',
                              Y201208: 126.90,
                              Y201209: 126.41,
                              Y201210: 126.41,
                              Y201211: 133.03,
                              Y201212: 133.34,
                              Y201301: 133.34,
                              Y201302: 133.45,
                              Y201303: 133.41,
                              Y201304: 133.59,
                              Y201305: 133.73,
                              Y201306: 134.05,
                              Y201307: 134.11,
                              Y201308: 134.19,
                              Items: [
                                {
                                  Cls: '콩류',
                                  Y201208: 115.27,
                                  Y201209: 115.27,
                                  Y201210: 116.50,
                                  Y201211: 123.18,
                                  Y201212: 127.39,
                                  Y201301: 128.93,
                                  Y201302: 130.71,
                                  Y201303: 130.78,
                                  Y201304: 130.80,
                                  Y201305: 131.34,
                                  Y201306: 131.33,
                                  Y201307: 131.56,
                                  Y201308: 130.49
                                },
                                {
                                  Cls: '감자류',
                                  Y201208: 125.61,
                                  Y201209: 129.54,
                                  Y201210: 104.94,
                                  Y201211: 95.84,
                                  Y201212: 96.02,
                                  Y201301: 101.00,
                                  Y201302: 107.46,
                                  Y201303: 96.37,
                                  Y201304: 79.59,
                                  Y201305: 85.08,
                                  Y201306: 90.49,
                                  Y201307: 85.53,
                                  Y201308: 108.04
                                }
                              ]
                            }
                          ]
                        },
                        {
                          Cls: '채소및과실',
                          Y201208: 125.33,
                          Y201209: 141.47,
                          Y201210: 123.21,
                          Y201211: 98.71,
                          Y201212: 108.00,
                          Y201301: 117.39,
                          Y201302: 121.85,
                          Y201303: 111.54,
                          Y201304: 108.03,
                          Y201305: 94.55,
                          Y201306: 87.83,
                          Y201307: 90.12,
                          Y201308: 104.75,
                          Items: [
                            {
                              Cls: '채소',
                              Y201208: 102.43,
                              Y201209: 123.36,
                              Y201210: 101.57,
                              Y201211: 98.16,
                              Y201212: 108.71,
                              Y201301: 120.76,
                              Y201302: 122.65,
                              Y201303: 109.06,
                              Y201304: 105.17,
                              Y201305: 86.84,
                              Y201306: 78.15,
                              Y201307: 81.38,
                              Y201308: 101.90
                            },
                            {
                              Cls: '과실',
                              Y201208: 205.35,
                              Y201209: 206.79,
                              Y201210: 199.05,
                              Y201211: 105.25,
                              Y201212: 110.92,
                              Y201301: 113.80,
                              Y201302: 125.13,
                              Y201303: 122.89,
                              Y201304: 120.22,
                              Y201305: 118.68,
                              Y201306: 116.74,
                              Y201307: 116.72,
                              Y201308: 116.72
                            },
                            {
                              Cls: '기타식용작물',
                              Y201208: 130.37,
                              Y201209: 123.08,
                              Y201210: 123.27,
                              Y201211: 127.74,
                              Y201212: 129.26,
                              Y201301: 128.54,
                              Y201302: 127.09,
                              Y201303: 123.71,
                              Y201304: 123.52,
                              Y201305: 129.09,
                              Y201306: 130.23,
                              Y201307: 127.62,
                              Y201308: 128.73
                            },
                            {
                              Cls: '약용작물',
                              Y201208: 136.27,
                              Y201209: 127.35,
                              Y201210: 127.30,
                              Y201211: 129.59,
                              Y201212: 131.08,
                              Y201301: 130.20,
                              Y201302: 128.52,
                              Y201303: 124.43,
                              Y201304: 123.27,
                              Y201305: 129.32,
                              Y201306: 130.56,
                              Y201307: 127.49,
                              Y201308: 128.73
                            },
                            {
                              Cls: '기타식용작물',
                              Y201208: 105.24,
                              Y201209: 104.52,
                              Y201210: 105.67,
                              Y201211: 118.75,
                              Y201212: 120.35,
                              Y201301: 120.66,
                              Y201302: 120.77,
                              Y201303: 122.28,
                              Y201304: 128.76,
                              Y201305: 131.13,
                              Y201306: 131.58,
                              Y201307: 132.17,
                              Y201308: 132.32
                            }
                          ]
                        },
                        {
                          Cls: '비식용작물',
                          Y201208: 56.51,
                          Y201209: 45.53,
                          Y201210: 39.64,
                          Y201211: 43.78,
                          Y201212: 50.54,
                          Y201301: 62.90,
                          Y201302: 83.62,
                          Y201303: 54.71,
                          Y201304: 42.05,
                          Y201305: 44.06,
                          Y201306: 39.35,
                          Y201307: 41.09,
                          Y201308: 55.30,
                          Items: [
                            {
                              Cls: '잎담배',
                              Y201208: 104.67,
                              Y201209: 104.67,
                              Y201210: 104.67,
                              Y201211: 104.67,
                              Y201212: 104.67,
                              Y201301: 104.67,
                              Y201302: 112.24,
                              Y201303: 112.24,
                              Y201304: 112.24,
                              Y201305: 112.24,
                              Y201306: 112.24,
                              Y201307: 112.24,
                              Y201308: 112.24
                            },
                            {
                              Cls: '화훼작물',
                              Y201208: 52.71,
                              Y201209: 40.91,
                              Y201210: 34.58,
                              Y201211: 39.03,
                              Y201212: 46.30,
                              Y201301: 59.89,
                              Y201302: 82.00,
                              Y201303: 50.22,
                              Y201304: 36.30,
                              Y201305: 38.50,
                              Y201306: 33.33,
                              Y201307: 35.24,
                              Y201308: 50.87
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '축산물',
                      Y201208: 97.29,
                      Y201209: 92.19,
                      Y201210: 85.37,
                      Y201211: 89.76,
                      Y201212: 87.86,
                      Y201301: 86.16,
                      Y201302: 85.69,
                      Y201303: 87.49,
                      Y201304: 90.61,
                      Y201305: 90.29,
                      Y201306: 96.02,
                      Y201307: 94.45,
                      Y201308: 97.23,
                      Items: [
                        {
                          Cls: '낙농및육류',
                          Y201208: 98.62,
                          Y201209: 91.10,
                          Y201210: 83.93,
                          Y201211: 89.61,
                          Y201212: 86.82,
                          Y201301: 85.22,
                          Y201302: 84.90,
                          Y201303: 86.54,
                          Y201304: 88.04,
                          Y201305: 87.37,
                          Y201306: 95.30,
                          Y201307: 92.98,
                          Y201308: 95.48,
                          Items: [
                            {
                              Cls: '낙농',
                              Y201208: 114.36,
                              Y201209: 114.69,
                              Y201210: 116.71,
                              Y201211: 117.86,
                              Y201212: 118.33,
                              Y201301: 117.87,
                              Y201302: 117.61,
                              Y201303: 117.40,
                              Y201304: 117.10,
                              Y201305: 116.28,
                              Y201306: 115.62,
                              Y201307: 114.85,
                              Y201308: 127.11
                            },
                            {
                              Cls: '육류',
                              Y201208: 96.18,
                              Y201209: 87.50,
                              Y201210: 78.97,
                              Y201211: 85.32,
                              Y201212: 82.05,
                              Y201301: 80.29,
                              Y201302: 79.95,
                              Y201303: 81.87,
                              Y201304: 83.63,
                              Y201305: 82.99,
                              Y201306: 92.17,
                              Y201307: 89.62,
                              Y201308: 90.68
                            }
                          ]
                        },
                        {
                          Cls: '기타축산',
                          Y201208: 87.20,
                          Y201209: 100.94,
                          Y201210: 96.87,
                          Y201211: 91.13,
                          Y201212: 96.23,
                          Y201301: 93.71,
                          Y201302: 92.24,
                          Y201303: 95.17,
                          Y201304: 110.44,
                          Y201305: 112.74,
                          Y201306: 102.06,
                          Y201307: 106.09,
                          Y201308: 111.02,
                          Items: [
                            {
                              Cls: '기타축산',
                              Y201208: 87.20,
                              Y201209: 100.94,
                              Y201210: 96.87,
                              Y201211: 91.13,
                              Y201212: 96.23,
                              Y201301: 93.71,
                              Y201302: 92.24,
                              Y201303: 95.17,
                              Y201304: 110.44,
                              Y201305: 112.74,
                              Y201306: 102.06,
                              Y201307: 106.09,
                              Y201308: 111.02
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '임산물',
                      Y201208: 167.80,
                      Y201209: 172.77,
                      Y201210: 159.93,
                      Y201211: 165.41,
                      Y201212: 164.74,
                      Y201301: 160.97,
                      Y201302: 174.20,
                      Y201303: 164.58,
                      Y201304: 164.58,
                      Y201305: 164.58,
                      Y201306: 164.58,
                      Y201307: 164.58,
                      Y201308: 164.58,
                      Items: [
                        {
                          Cls: '임산물',
                          Y201208: 167.80,
                          Y201209: 172.77,
                          Y201210: 159.93,
                          Y201211: 165.41,
                          Y201212: 164.74,
                          Y201301: 160.97,
                          Y201302: 174.20,
                          Y201303: 164.58,
                          Y201304: 164.58,
                          Y201305: 164.58,
                          Y201306: 164.58,
                          Y201307: 164.58,
                          Y201308: 164.58,
                          Items: [
                            {
                              Cls: '원목',
                              Y201208: 101.66,
                              Y201209: 101.66,
                              Y201210: 101.66,
                              Y201211: 101.66,
                              Y201212: 101.66,
                              Y201301: 101.66,
                              Y201302: 101.66,
                              Y201303: 101.66,
                              Y201304: 101.66,
                              Y201305: 101.66,
                              Y201306: 101.66,
                              Y201307: 101.66,
                              Y201308: 101.66
                            },
                            {
                              Cls: '식용임산물',
                              Y201208: 179.74,
                              Y201209: 185.68,
                              Y201210: 170.36,
                              Y201211: 176.90,
                              Y201212: 176.09,
                              Y201301: 171.65,
                              Y201302: 187.20,
                              Y201303: 175.90,
                              Y201304: 175.90,
                              Y201305: 175.90,
                              Y201306: 175.90,
                              Y201307: 175.90,
                              Y201308: 175.90
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '수산물',
                      Y201208: 96.58,
                      Y201209: 97.16,
                      Y201210: 95.66,
                      Y201211: 93.57,
                      Y201212: 95.32,
                      Y201301: 95.34,
                      Y201302: 95.15,
                      Y201303: 93.75,
                      Y201304: 94.95,
                      Y201305: 96.69,
                      Y201306: 90.24,
                      Y201307: 93.74,
                      Y201308: 93.70,
                      Items: [
                        {
                          Cls: '신선수산물',
                          Y201208: 92.80,
                          Y201209: 93.41,
                          Y201210: 90.15,
                          Y201211: 87.68,
                          Y201212: 90.57,
                          Y201301: 90.90,
                          Y201302: 90.85,
                          Y201303: 90.04,
                          Y201304: 91.85,
                          Y201305: 86.35,
                          Y201306: 86.39,
                          Y201307: 90.20,
                          Y201308: 89.72,
                          Items: [
                            {
                              Cls: '신선어류',
                              Y201208: 88.70,
                              Y201209: 90.15,
                              Y201210: 88.31,
                              Y201211: 83.24,
                              Y201212: 85.88,
                              Y201301: 89.44,
                              Y201302: 92.92,
                              Y201303: 92.81,
                              Y201304: 95.45,
                              Y201305: 84.96,
                              Y201306: 86.34,
                              Y201307: 88.64,
                              Y201308: 88.57
                            },
                            {
                              Cls: '신선갑각류',
                              Y201208: 84.08,
                              Y201209: 61.12,
                              Y201210: 64.17,
                              Y201211: 86.46,
                              Y201212: 105.86,
                              Y201301: 86.83,
                              Y201302: 55.50,
                              Y201303: 55.50,
                              Y201304: 55.50,
                              Y201305: 77.85,
                              Y201306: 77.17,
                              Y201307: 77.17,
                              Y201308: 77.16
                            },
                            {
                              Cls: '신선패류',
                              Y201208: 107.27,
                              Y201209: 106.07,
                              Y201210: 100.89,
                              Y201211: 103.31,
                              Y201212: 106.98,
                              Y201301: 105.35,
                              Y201302: 101.44,
                              Y201303: 93.15,
                              Y201304: 94.72,
                              Y201305: 94.88,
                              Y201306: 91.49,
                              Y201307: 100.56,
                              Y201308: 102.66
                            },
                            {
                              Cls: '신선연체류',
                              Y201208: 93.70,
                              Y201209: 97.73,
                              Y201210: 90.55,
                              Y201211: 87.71,
                              Y201212: 87.35,
                              Y201301: 84.42,
                              Y201302: 87.18,
                              Y201303: 88.94,
                              Y201304: 88.08,
                              Y201305: 86.73,
                              Y201306: 83.93,
                              Y201307: 91.94,
                              Y201308: 87.31
                            }
                          ]
                        },
                        {
                          Cls: '냉동건조수산물',
                          Y201208: 105.47,
                          Y201209: 106.00,
                          Y201210: 108.52,
                          Y201211: 107.32,
                          Y201212: 106.46,
                          Y201301: 105.85,
                          Y201302: 105.35,
                          Y201303: 102.73,
                          Y201304: 102.69,
                          Y201305: 119.36,
                          Y201306: 99.45,
                          Y201307: 102.37,
                          Y201308: 103.23,
                          Items: [
                            {
                              Cls: '냉동수산물',
                              Y201208: 104.54,
                              Y201209: 104.63,
                              Y201210: 104.43,
                              Y201211: 103.70,
                              Y201212: 103.47,
                              Y201301: 103.50,
                              Y201302: 103.48,
                              Y201303: 103.55,
                              Y201304: 104.18,
                              Y201305: 127.36,
                              Y201306: 98.54,
                              Y201307: 103.87,
                              Y201308: 104.93
                            },
                            {
                              Cls: '건조수산물',
                              Y201208: 107.39,
                              Y201209: 108.87,
                              Y201210: 117.09,
                              Y201211: 114.87,
                              Y201212: 112.70,
                              Y201301: 110.47,
                              Y201302: 108.80,
                              Y201303: 99.32,
                              Y201304: 97.60,
                              Y201305: 97.51,
                              Y201306: 100.49,
                              Y201307: 97.23,
                              Y201308: 97.62
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              Cls: '광산품',
              Y201208: 105.86,
              Y201209: 105.26,
              Y201210: 105.17,
              Y201211: 105.17,
              Y201212: 105.67,
              Y201301: 105.47,
              Y201302: 107.42,
              Y201303: 107.47,
              Y201304: 107.52,
              Y201305: 107.67,
              Y201306: 107.54,
              Y201307: 108.29,
              Y201308: 108.23,
              Items: [
                {
                  Cls: '광산품',
                  Y201208: 105.86,
                  Y201209: 105.26,
                  Y201210: 105.17,
                  Y201211: 105.17,
                  Y201212: 105.67,
                  Y201301: 105.47,
                  Y201302: 107.42,
                  Y201303: 107.47,
                  Y201304: 107.52,
                  Y201305: 107.67,
                  Y201306: 107.54,
                  Y201307: 108.29,
                  Y201308: 108.23,
                  Items: [
                    {
                      Cls: '석탄,원유및천연가스',
                      Y201208: 116.44,
                      Y201209: 112.30,
                      Y201210: 111.78,
                      Y201211: 111.78,
                      Y201212: 115.15,
                      Y201301: 113.84,
                      Y201302: 114.49,
                      Y201303: 114.84,
                      Y201304: 115.13,
                      Y201305: 116.77,
                      Y201306: 115.93,
                      Y201307: 114.11,
                      Y201308: 113.66,
                      Items: [
                        {
                          Cls: '석탄',
                          Y201208: 115.00,
                          Y201209: 115.00,
                          Y201210: 115.00,
                          Y201211: 115.00,
                          Y201212: 115.00,
                          Y201301: 115.00,
                          Y201302: 115.00,
                          Y201303: 115.00,
                          Y201304: 115.00,
                          Y201305: 115.00,
                          Y201306: 115.00,
                          Y201307: 114.64,
                          Y201308: 115.47,
                          Items: [
                            {
                              Cls: '무연탄',
                              Y201208: 115.00,
                              Y201209: 115.00,
                              Y201210: 115.00,
                              Y201211: 115.00,
                              Y201212: 115.00,
                              Y201301: 115.00,
                              Y201302: 115.00,
                              Y201303: 115.00,
                              Y201304: 115.00,
                              Y201305: 115.00,
                              Y201306: 115.00,
                              Y201307: 114.64,
                              Y201308: 115.47
                            }
                          ]
                        },
                        {
                          Cls: '원유및천연가스',
                          Y201208: 121.44,
                          Y201209: 110.66,
                          Y201210: 109.31,
                          Y201211: 109.31,
                          Y201212: 118.07,
                          Y201301: 115.38,
                          Y201302: 116.72,
                          Y201303: 117.42,
                          Y201304: 118.02,
                          Y201305: 121.39,
                          Y201306: 119.68,
                          Y201307: 116.31,
                          Y201308: 114.54,
                          Items: [
                            {
                              Cls: '천연가스(LNG)',
                              Y201208: 121.44,
                              Y201209: 110.66,
                              Y201210: 109.31,
                              Y201211: 109.31,
                              Y201212: 118.07,
                              Y201301: 115.38,
                              Y201302: 116.72,
                              Y201303: 117.42,
                              Y201304: 118.02,
                              Y201305: 121.39,
                              Y201306: 119.68,
                              Y201307: 116.31,
                              Y201308: 114.54
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '비금속광물',
                      Y201208: 103.90,
                      Y201209: 103.90,
                      Y201210: 103.90,
                      Y201211: 103.90,
                      Y201212: 103.90,
                      Y201301: 103.90,
                      Y201302: 106.08,
                      Y201303: 106.08,
                      Y201304: 106.08,
                      Y201305: 105.96,
                      Y201306: 105.96,
                      Y201307: 107.18,
                      Y201308: 107.18,
                      Items: [
                        {
                          Cls: '비금속광물',
                          Y201208: 103.90,
                          Y201209: 103.90,
                          Y201210: 103.90,
                          Y201211: 103.90,
                          Y201212: 103.90,
                          Y201301: 103.90,
                          Y201302: 106.08,
                          Y201303: 106.08,
                          Y201304: 106.08,
                          Y201305: 105.96,
                          Y201306: 105.96,
                          Y201307: 107.18,
                          Y201308: 107.18,
                          Items: [
                            {
                              Cls: '골재및석재',
                              Y201208: 103.40,
                              Y201209: 103.40,
                              Y201210: 103.40,
                              Y201211: 103.40,
                              Y201212: 103.40,
                              Y201301: 103.40,
                              Y201302: 103.40,
                              Y201303: 103.40,
                              Y201304: 103.40,
                              Y201305: 103.20,
                              Y201306: 103.20,
                              Y201307: 105.22,
                              Y201308: 105.22
                            },
                            {
                              Cls: '석회석',
                              Y201208: 105.15,
                              Y201209: 105.15,
                              Y201210: 105.15,
                              Y201211: 105.15,
                              Y201212: 105.15,
                              Y201301: 105.15,
                              Y201302: 111.46,
                              Y201303: 111.46,
                              Y201304: 111.46,
                              Y201305: 111.46,
                              Y201306: 111.46,
                              Y201307: 111.46,
                              Y201308: 111.46
                            },
                            {
                              Cls: '기타비금속광물',
                              Y201208: 103.85,
                              Y201209: 103.85,
                              Y201210: 103.85,
                              Y201211: 103.85,
                              Y201212: 103.85,
                              Y201301: 103.85,
                              Y201302: 103.85,
                              Y201303: 103.85,
                              Y201304: 103.85,
                              Y201305: 103.85,
                              Y201306: 103.85,
                              Y201307: 103.85,
                              Y201308: 103.85
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              Cls: '공산품',
              Y201208: 107.86,
              Y201209: 108.41,
              Y201210: 107.39,
              Y201211: 106.45,
              Y201212: 105.85,
              Y201301: 106.01,
              Y201302: 106.88,
              Y201303: 106.20,
              Y201304: 105.68,
              Y201305: 105.21,
              Y201306: 105.27,
              Y201307: 105.10,
              Y201308: 105.16,
              Items: [
                {
                  Cls: '음식료품',
                  Y201208: 111.16,
                  Y201209: 111.26,
                  Y201210: 111.45,
                  Y201211: 111.53,
                  Y201212: 111.54,
                  Y201301: 112.05,
                  Y201302: 112.11,
                  Y201303: 112.10,
                  Y201304: 112.18,
                  Y201305: 112.31,
                  Y201306: 112.27,
                  Y201307: 112.31,
                  Y201308: 112.27,
                  Items: [
                    {
                      Cls: '식료품',
                      Y201208: 111.05,
                      Y201209: 111.17,
                      Y201210: 111.49,
                      Y201211: 111.63,
                      Y201212: 111.28,
                      Y201301: 111.66,
                      Y201302: 111.74,
                      Y201303: 111.68,
                      Y201304: 111.79,
                      Y201305: 111.83,
                      Y201306: 111.77,
                      Y201307: 111.84,
                      Y201308: 111.77,
                      Items: [
                        {
                          Cls: '육가공품및낙농품',
                          Y201208: 103.37,
                          Y201209: 102.93,
                          Y201210: 101.98,
                          Y201211: 101.91,
                          Y201212: 102.02,
                          Y201301: 101.84,
                          Y201302: 101.62,
                          Y201303: 101.41,
                          Y201304: 101.62,
                          Y201305: 101.76,
                          Y201306: 101.91,
                          Y201307: 102.10,
                          Y201308: 102.09,
                          Items: [
                            {
                              Cls: '육가공품',
                              Y201208: 90.63,
                              Y201209: 89.10,
                              Y201210: 85.84,
                              Y201211: 85.60,
                              Y201212: 85.95,
                              Y201301: 85.54,
                              Y201302: 84.80,
                              Y201303: 84.06,
                              Y201304: 84.82,
                              Y201305: 85.29,
                              Y201306: 85.80,
                              Y201307: 86.50,
                              Y201308: 86.47
                            },
                            {
                              Cls: '우유',
                              Y201208: 112.70,
                              Y201209: 112.70,
                              Y201210: 112.70,
                              Y201211: 112.70,
                              Y201212: 112.70,
                              Y201301: 112.70,
                              Y201302: 112.70,
                              Y201303: 112.70,
                              Y201304: 112.70,
                              Y201305: 112.70,
                              Y201306: 112.70,
                              Y201307: 112.70,
                              Y201308: 112.70
                            },
                            {
                              Cls: '낙농품',
                              Y201208: 105.33,
                              Y201209: 105.33,
                              Y201210: 105.33,
                              Y201211: 105.33,
                              Y201212: 105.33,
                              Y201301: 105.19,
                              Y201302: 105.19,
                              Y201303: 105.19,
                              Y201304: 105.19,
                              Y201305: 105.19,
                              Y201306: 105.19,
                              Y201307: 105.16,
                              Y201308: 105.16
                            }
                          ]
                        },
                        {
                          Cls: '수산가공품',
                          Y201208: 121.78,
                          Y201209: 121.82,
                          Y201210: 121.42,
                          Y201211: 120.98,
                          Y201212: 120.41,
                          Y201301: 120.39,
                          Y201302: 120.40,
                          Y201303: 121.10,
                          Y201304: 121.72,
                          Y201305: 121.69,
                          Y201306: 121.40,
                          Y201307: 120.95,
                          Y201308: 120.76,
                          Items: [
                            {
                              Cls: '수산물가공품',
                              Y201208: 126.03,
                              Y201209: 126.07,
                              Y201210: 125.77,
                              Y201211: 125.22,
                              Y201212: 124.50,
                              Y201301: 124.46,
                              Y201302: 124.49,
                              Y201303: 125.35,
                              Y201304: 126.16,
                              Y201305: 126.09,
                              Y201306: 125.89,
                              Y201307: 125.43,
                              Y201308: 125.17
                            },
                            {
                              Cls: '수산동물저장품',
                              Y201208: 105.88,
                              Y201209: 105.88,
                              Y201210: 105.10,
                              Y201211: 105.10,
                              Y201212: 105.10,
                              Y201301: 105.10,
                              Y201302: 105.10,
                              Y201303: 105.10,
                              Y201304: 105.01,
                              Y201305: 105.01,
                              Y201306: 104.40,
                              Y201307: 103.95,
                              Y201308: 104.08
                            }
                          ]
                        },
                        {
                          Cls: '정곡및제분',
                          Y201208: 106.27,
                          Y201209: 106.27,
                          Y201210: 106.27,
                          Y201211: 106.27,
                          Y201212: 106.27,
                          Y201301: 110.96,
                          Y201302: 110.96,
                          Y201303: 114.78,
                          Y201304: 114.78,
                          Y201305: 114.78,
                          Y201306: 114.78,
                          Y201307: 114.78,
                          Y201308: 114.78,
                          Items: [
                            {
                              Cls: '제분',
                              Y201208: 106.27,
                              Y201209: 106.27,
                              Y201210: 106.27,
                              Y201211: 106.27,
                              Y201212: 106.27,
                              Y201301: 110.96,
                              Y201302: 110.96,
                              Y201303: 114.78,
                              Y201304: 114.78,
                              Y201305: 114.78,
                              Y201306: 114.78,
                              Y201307: 114.78,
                              Y201308: 114.78
                            }
                          ]
                        },
                        {
                          Cls: '제당및전분',
                          Y201208: 123.21,
                          Y201209: 119.86,
                          Y201210: 119.86,
                          Y201211: 119.86,
                          Y201212: 120.15,
                          Y201301: 121.35,
                          Y201302: 123.13,
                          Y201303: 119.41,
                          Y201304: 119.41,
                          Y201305: 119.41,
                          Y201306: 119.41,
                          Y201307: 119.41,
                          Y201308: 119.41,
                          Items: [
                            {
                              Cls: '정제당',
                              Y201208: 131.06,
                              Y201209: 124.38,
                              Y201210: 124.38,
                              Y201211: 124.38,
                              Y201212: 124.38,
                              Y201301: 124.38,
                              Y201302: 124.38,
                              Y201303: 116.68,
                              Y201304: 116.68,
                              Y201305: 116.68,
                              Y201306: 116.68,
                              Y201307: 116.68,
                              Y201308: 116.68
                            },
                            {
                              Cls: '전분및당류',
                              Y201208: 115.07,
                              Y201209: 115.07,
                              Y201210: 115.07,
                              Y201211: 115.07,
                              Y201212: 115.67,
                              Y201301: 117.99,
                              Y201302: 121.41,
                              Y201303: 121.41,
                              Y201304: 121.41,
                              Y201305: 121.41,
                              Y201306: 121.41,
                              Y201307: 121.41,
                              Y201308: 121.41
                            }
                          ]
                        },
                        {
                          Cls: '떡,과자및면류',
                          Y201208: 106.90,
                          Y201209: 108.16,
                          Y201210: 108.32,
                          Y201211: 108.32,
                          Y201212: 108.32,
                          Y201301: 108.32,
                          Y201302: 108.32,
                          Y201303: 108.51,
                          Y201304: 108.54,
                          Y201305: 108.54,
                          Y201306: 108.54,
                          Y201307: 108.54,
                          Y201308: 108.54,
                          Items: [
                            {
                              Cls: '떡,빵및과자류',
                              Y201208: 107.79,
                              Y201209: 108.98,
                              Y201210: 109.20,
                              Y201211: 109.20,
                              Y201212: 109.20,
                              Y201301: 109.20,
                              Y201302: 109.20,
                              Y201303: 109.45,
                              Y201304: 109.45,
                              Y201305: 109.45,
                              Y201306: 109.45,
                              Y201307: 109.45,
                              Y201308: 109.45
                            },
                            {
                              Cls: '면류',
                              Y201208: 103.70,
                              Y201209: 105.13,
                              Y201210: 105.13,
                              Y201211: 105.13,
                              Y201212: 105.13,
                              Y201301: 105.13,
                              Y201302: 105.13,
                              Y201303: 105.13,
                              Y201304: 105.25,
                              Y201305: 105.25,
                              Y201306: 105.25,
                              Y201307: 105.25,
                              Y201308: 105.25
                            }
                          ]
                        },
                        {
                          Cls: '조미료및유지',
                          Y201208: 113.38,
                          Y201209: 113.82,
                          Y201210: 114.29,
                          Y201211: 114.09,
                          Y201212: 111.74,
                          Y201301: 112.40,
                          Y201302: 112.37,
                          Y201303: 112.20,
                          Y201304: 112.20,
                          Y201305: 112.37,
                          Y201306: 112.38,
                          Y201307: 112.71,
                          Y201308: 112.21,
                          Items: [
                            {
                              Cls: '조미료및첨가용식품',
                              Y201208: 113.61,
                              Y201209: 113.61,
                              Y201210: 113.61,
                              Y201211: 113.61,
                              Y201212: 110.73,
                              Y201301: 111.14,
                              Y201302: 111.25,
                              Y201303: 111.25,
                              Y201304: 111.25,
                              Y201305: 111.51,
                              Y201306: 111.52,
                              Y201307: 111.52,
                              Y201308: 110.86
                            },
                            {
                              Cls: '유지',
                              Y201208: 113.73,
                              Y201209: 114.92,
                              Y201210: 116.21,
                              Y201211: 115.65,
                              Y201212: 114.21,
                              Y201301: 115.27,
                              Y201302: 115.01,
                              Y201303: 114.59,
                              Y201304: 114.58,
                              Y201305: 114.59,
                              Y201306: 114.61,
                              Y201307: 115.49,
                              Y201308: 115.23
                            }
                          ]
                        },
                        {
                          Cls: '기타식료품',
                          Y201208: 115.61,
                          Y201209: 115.84,
                          Y201210: 117.68,
                          Y201211: 118.63,
                          Y201212: 118.72,
                          Y201301: 118.97,
                          Y201302: 119.15,
                          Y201303: 119.02,
                          Y201304: 119.06,
                          Y201305: 118.99,
                          Y201306: 118.68,
                          Y201307: 118.64,
                          Y201308: 118.79,
                          Items: [
                            {
                              Cls: '과실및채소가공품',
                              Y201208: 114.73,
                              Y201209: 115.61,
                              Y201210: 122.69,
                              Y201211: 123.72,
                              Y201212: 123.48,
                              Y201301: 123.55,
                              Y201302: 124.38,
                              Y201303: 123.71,
                              Y201304: 123.65,
                              Y201305: 123.67,
                              Y201306: 122.75,
                              Y201307: 122.78,
                              Y201308: 122.94
                            },
                            {
                              Cls: '커피및차류',
                              Y201208: 108.16,
                              Y201209: 108.16,
                              Y201210: 108.16,
                              Y201211: 108.16,
                              Y201212: 108.16,
                              Y201301: 108.16,
                              Y201302: 108.16,
                              Y201303: 108.16,
                              Y201304: 108.16,
                              Y201305: 108.16,
                              Y201306: 108.16,
                              Y201307: 108.16,
                              Y201308: 108.16
                            },
                            {
                              Cls: '인삼및건강보조식품',
                              Y201208: 126.92,
                              Y201209: 126.92,
                              Y201210: 127.44,
                              Y201211: 127.44,
                              Y201212: 127.44,
                              Y201301: 127.44,
                              Y201302: 127.44,
                              Y201303: 127.44,
                              Y201304: 127.44,
                              Y201305: 127.44,
                              Y201306: 127.44,
                              Y201307: 127.44,
                              Y201308: 127.44
                            },
                            {
                              Cls: '기타식료품',
                              Y201208: 115.75,
                              Y201209: 115.75,
                              Y201210: 115.55,
                              Y201211: 116.96,
                              Y201212: 117.26,
                              Y201301: 117.74,
                              Y201302: 117.65,
                              Y201303: 117.74,
                              Y201304: 117.87,
                              Y201305: 117.72,
                              Y201306: 117.59,
                              Y201307: 117.47,
                              Y201308: 117.71
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '음료품',
                      Y201208: 108.34,
                      Y201209: 108.40,
                      Y201210: 108.45,
                      Y201211: 108.47,
                      Y201212: 109.56,
                      Y201301: 109.98,
                      Y201302: 109.98,
                      Y201303: 110.20,
                      Y201304: 110.20,
                      Y201305: 110.20,
                      Y201306: 110.20,
                      Y201307: 110.20,
                      Y201308: 110.20,
                      Items: [
                        {
                          Cls: '주류',
                          Y201208: 103.44,
                          Y201209: 103.54,
                          Y201210: 103.54,
                          Y201211: 103.57,
                          Y201212: 105.68,
                          Y201301: 106.49,
                          Y201302: 106.49,
                          Y201303: 106.49,
                          Y201304: 106.49,
                          Y201305: 106.49,
                          Y201306: 106.49,
                          Y201307: 106.49,
                          Y201308: 106.49,
                          Items: [
                            {
                              Cls: '주정',
                              Y201208: 105.82,
                              Y201209: 105.82,
                              Y201210: 105.82,
                              Y201211: 105.82,
                              Y201212: 106.04,
                              Y201301: 106.04,
                              Y201302: 106.04,
                              Y201303: 106.04,
                              Y201304: 106.04,
                              Y201305: 106.04,
                              Y201306: 106.04,
                              Y201307: 106.04,
                              Y201308: 106.04
                            },
                            {
                              Cls: '소주',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 106.52,
                              Y201301: 108.34,
                              Y201302: 108.34,
                              Y201303: 108.34,
                              Y201304: 108.34,
                              Y201305: 108.34,
                              Y201306: 108.34,
                              Y201307: 108.34,
                              Y201308: 108.34
                            },
                            {
                              Cls: '맥주',
                              Y201208: 105.91,
                              Y201209: 105.91,
                              Y201210: 105.91,
                              Y201211: 105.91,
                              Y201212: 105.91,
                              Y201301: 105.91,
                              Y201302: 105.91,
                              Y201303: 105.91,
                              Y201304: 105.91,
                              Y201305: 105.91,
                              Y201306: 105.91,
                              Y201307: 105.91,
                              Y201308: 105.91
                            },
                            {
                              Cls: '기타주류',
                              Y201208: 101.54,
                              Y201209: 102.28,
                              Y201210: 102.28,
                              Y201211: 102.45,
                              Y201212: 102.45,
                              Y201301: 103.74,
                              Y201302: 103.74,
                              Y201303: 103.74,
                              Y201304: 103.74,
                              Y201305: 103.74,
                              Y201306: 103.74,
                              Y201307: 103.74,
                              Y201308: 103.74
                            }
                          ]
                        },
                        {
                          Cls: '청량음료및생수',
                          Y201208: 113.66,
                          Y201209: 113.66,
                          Y201210: 113.76,
                          Y201211: 113.76,
                          Y201212: 113.76,
                          Y201301: 113.76,
                          Y201302: 113.76,
                          Y201303: 114.22,
                          Y201304: 114.22,
                          Y201305: 114.22,
                          Y201306: 114.22,
                          Y201307: 114.22,
                          Y201308: 114.22,
                          Items: [
                            {
                              Cls: '비알콜음료및얼음',
                              Y201208: 113.66,
                              Y201209: 113.66,
                              Y201210: 113.76,
                              Y201211: 113.76,
                              Y201212: 113.76,
                              Y201301: 113.76,
                              Y201302: 113.76,
                              Y201303: 114.22,
                              Y201304: 114.22,
                              Y201305: 114.22,
                              Y201306: 114.22,
                              Y201307: 114.22,
                              Y201308: 114.22
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '사료',
                      Y201208: 115.43,
                      Y201209: 115.43,
                      Y201210: 115.36,
                      Y201211: 115.21,
                      Y201212: 115.79,
                      Y201301: 117.13,
                      Y201302: 117.13,
                      Y201303: 117.13,
                      Y201304: 117.13,
                      Y201305: 117.85,
                      Y201306: 117.85,
                      Y201307: 117.85,
                      Y201308: 117.85,
                      Items: [
                        {
                          Cls: '사료',
                          Y201208: 115.43,
                          Y201209: 115.43,
                          Y201210: 115.36,
                          Y201211: 115.21,
                          Y201212: 115.79,
                          Y201301: 117.13,
                          Y201302: 117.13,
                          Y201303: 117.13,
                          Y201304: 117.13,
                          Y201305: 117.85,
                          Y201306: 117.85,
                          Y201307: 117.85,
                          Y201308: 117.85,
                          Items: [
                            {
                              Cls: '사료',
                              Y201208: 115.43,
                              Y201209: 115.43,
                              Y201210: 115.36,
                              Y201211: 115.21,
                              Y201212: 115.79,
                              Y201301: 117.13,
                              Y201302: 117.13,
                              Y201303: 117.13,
                              Y201304: 117.13,
                              Y201305: 117.85,
                              Y201306: 117.85,
                              Y201307: 117.85,
                              Y201308: 117.85
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '담배',
                      Y201208: 108.63,
                      Y201209: 108.63,
                      Y201210: 108.63,
                      Y201211: 108.63,
                      Y201212: 108.63,
                      Y201301: 108.63,
                      Y201302: 108.63,
                      Y201303: 108.63,
                      Y201304: 108.63,
                      Y201305: 108.63,
                      Y201306: 108.63,
                      Y201307: 108.63,
                      Y201308: 108.63,
                      Items: [
                        {
                          Cls: '담배',
                          Y201208: 108.63,
                          Y201209: 108.63,
                          Y201210: 108.63,
                          Y201211: 108.63,
                          Y201212: 108.63,
                          Y201301: 108.63,
                          Y201302: 108.63,
                          Y201303: 108.63,
                          Y201304: 108.63,
                          Y201305: 108.63,
                          Y201306: 108.63,
                          Y201307: 108.63,
                          Y201308: 108.63,
                          Items: [
                            {
                              Cls: '담배',
                              Y201208: 108.63,
                              Y201209: 108.63,
                              Y201210: 108.63,
                              Y201211: 108.63,
                              Y201212: 108.63,
                              Y201301: 108.63,
                              Y201302: 108.63,
                              Y201303: 108.63,
                              Y201304: 108.63,
                              Y201305: 108.63,
                              Y201306: 108.63,
                              Y201307: 108.63,
                              Y201308: 108.63
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '섬유및가죽제품',
                  Y201208: 110.58,
                  Y201209: 111.47,
                  Y201210: 111.26,
                  Y201211: 111.12,
                  Y201212: 110.99,
                  Y201301: 111.08,
                  Y201302: 110.92,
                  Y201303: 111.32,
                  Y201304: 111.66,
                  Y201305: 111.49,
                  Y201306: 111.67,
                  Y201307: 111.79,
                  Y201308: 111.88,
                  Items: [
                    {
                      Cls: '섬유사및직물',
                      Y201208: 106.66,
                      Y201209: 106.31,
                      Y201210: 105.67,
                      Y201211: 105.14,
                      Y201212: 104.74,
                      Y201301: 105.37,
                      Y201302: 105.82,
                      Y201303: 106.99,
                      Y201304: 107.46,
                      Y201305: 106.37,
                      Y201306: 106.09,
                      Y201307: 106.64,
                      Y201308: 106.79,
                      Items: [
                        {
                          Cls: '섬유사',
                          Y201208: 103.26,
                          Y201209: 103.08,
                          Y201210: 102.86,
                          Y201211: 102.33,
                          Y201212: 102.00,
                          Y201301: 103.57,
                          Y201302: 104.19,
                          Y201303: 105.60,
                          Y201304: 105.87,
                          Y201305: 104.24,
                          Y201306: 103.18,
                          Y201307: 104.13,
                          Y201308: 104.12,
                          Items: [
                            {
                              Cls: '천연섬유사',
                              Y201208: 96.75,
                              Y201209: 95.74,
                              Y201210: 95.37,
                              Y201211: 95.09,
                              Y201212: 94.56,
                              Y201301: 94.85,
                              Y201302: 95.81,
                              Y201303: 98.30,
                              Y201304: 99.36,
                              Y201305: 97.06,
                              Y201306: 96.18,
                              Y201307: 96.15,
                              Y201308: 96.13
                            },
                            {
                              Cls: '화학섬유사',
                              Y201208: 97.91,
                              Y201209: 100.29,
                              Y201210: 100.29,
                              Y201211: 98.35,
                              Y201212: 98.35,
                              Y201301: 105.06,
                              Y201302: 106.19,
                              Y201303: 107.79,
                              Y201304: 107.79,
                              Y201305: 104.55,
                              Y201306: 98.10,
                              Y201307: 101.97,
                              Y201308: 101.97
                            },
                            {
                              Cls: '기타섬유사',
                              Y201208: 117.41,
                              Y201209: 117.41,
                              Y201210: 117.41,
                              Y201211: 117.41,
                              Y201212: 117.41,
                              Y201301: 118.00,
                              Y201302: 118.00,
                              Y201303: 118.00,
                              Y201304: 117.41,
                              Y201305: 117.41,
                              Y201306: 118.83,
                              Y201307: 119.55,
                              Y201308: 119.55
                            }
                          ]
                        },
                        {
                          Cls: '섬유직물',
                          Y201208: 110.89,
                          Y201209: 110.35,
                          Y201210: 109.19,
                          Y201211: 108.68,
                          Y201212: 108.17,
                          Y201301: 107.96,
                          Y201302: 108.26,
                          Y201303: 109.23,
                          Y201304: 109.90,
                          Y201305: 109.28,
                          Y201306: 109.68,
                          Y201307: 109.86,
                          Y201308: 110.18,
                          Items: [
                            {
                              Cls: '천연섬유직물',
                              Y201208: 117.69,
                              Y201209: 118.41,
                              Y201210: 118.41,
                              Y201211: 118.41,
                              Y201212: 118.41,
                              Y201301: 119.08,
                              Y201302: 119.75,
                              Y201303: 119.75,
                              Y201304: 120.07,
                              Y201305: 120.07,
                              Y201306: 120.07,
                              Y201307: 120.85,
                              Y201308: 121.26
                            },
                            {
                              Cls: '화학섬유직물',
                              Y201208: 108.82,
                              Y201209: 108.68,
                              Y201210: 107.99,
                              Y201211: 107.22,
                              Y201212: 106.80,
                              Y201301: 106.34,
                              Y201302: 106.34,
                              Y201303: 107.79,
                              Y201304: 108.18,
                              Y201305: 107.74,
                              Y201306: 107.74,
                              Y201307: 107.74,
                              Y201308: 107.99
                            },
                            {
                              Cls: '기타섬유직물',
                              Y201208: 107.79,
                              Y201209: 104.91,
                              Y201210: 101.42,
                              Y201211: 100.85,
                              Y201212: 99.56,
                              Y201301: 99.08,
                              Y201302: 99.61,
                              Y201303: 100.48,
                              Y201304: 101.95,
                              Y201305: 100.50,
                              Y201306: 101.99,
                              Y201307: 101.99,
                              Y201308: 102.37
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '섬유및의복제품',
                      Y201208: 112.42,
                      Y201209: 113.64,
                      Y201210: 113.62,
                      Y201211: 113.55,
                      Y201212: 113.47,
                      Y201301: 113.47,
                      Y201302: 113.06,
                      Y201303: 113.31,
                      Y201304: 113.63,
                      Y201305: 113.54,
                      Y201306: 113.87,
                      Y201307: 113.89,
                      Y201308: 113.87,
                      Items: [
                        {
                          Cls: '섬유및직물제품',
                          Y201208: 109.86,
                          Y201209: 109.90,
                          Y201210: 109.69,
                          Y201211: 109.51,
                          Y201212: 109.35,
                          Y201301: 109.35,
                          Y201302: 109.26,
                          Y201303: 109.45,
                          Y201304: 109.89,
                          Y201305: 109.75,
                          Y201306: 109.67,
                          Y201307: 109.55,
                          Y201308: 109.55,
                          Items: [
                            {
                              Cls: '직물제품',
                              Y201208: 109.43,
                              Y201209: 109.43,
                              Y201210: 109.24,
                              Y201211: 109.24,
                              Y201212: 109.04,
                              Y201301: 109.04,
                              Y201302: 108.88,
                              Y201303: 108.88,
                              Y201304: 109.08,
                              Y201305: 109.08,
                              Y201306: 109.08,
                              Y201307: 109.08,
                              Y201308: 109.08
                            },
                            {
                              Cls: '끈,로프및어망',
                              Y201208: 112.11,
                              Y201209: 113.12,
                              Y201210: 114.11,
                              Y201211: 114.11,
                              Y201212: 114.11,
                              Y201301: 114.11,
                              Y201302: 114.61,
                              Y201303: 115.10,
                              Y201304: 115.10,
                              Y201305: 115.10,
                              Y201306: 115.10,
                              Y201307: 115.10,
                              Y201308: 115.10
                            },
                            {
                              Cls: '기타섬유제품',
                              Y201208: 110.42,
                              Y201209: 110.17,
                              Y201210: 109.43,
                              Y201211: 108.74,
                              Y201212: 108.59,
                              Y201301: 108.59,
                              Y201302: 108.48,
                              Y201303: 108.93,
                              Y201304: 109.90,
                              Y201305: 109.50,
                              Y201306: 109.24,
                              Y201307: 108.88,
                              Y201308: 108.88
                            }
                          ]
                        },
                        {
                          Cls: '봉제및편조의류',
                          Y201208: 113.08,
                          Y201209: 114.68,
                          Y201210: 114.73,
                          Y201211: 114.71,
                          Y201212: 114.65,
                          Y201301: 114.65,
                          Y201302: 114.09,
                          Y201303: 114.36,
                          Y201304: 114.65,
                          Y201305: 114.56,
                          Y201306: 115.06,
                          Y201307: 115.14,
                          Y201308: 115.10,
                          Items: [
                            {
                              Cls: '봉제의류',
                              Y201208: 107.14,
                              Y201209: 108.97,
                              Y201210: 109.04,
                              Y201211: 109.00,
                              Y201212: 108.94,
                              Y201301: 108.94,
                              Y201302: 108.30,
                              Y201303: 108.61,
                              Y201304: 108.94,
                              Y201305: 108.84,
                              Y201306: 109.42,
                              Y201307: 109.50,
                              Y201308: 109.45
                            },
                            {
                              Cls: '편조의류',
                              Y201208: 152.72,
                              Y201209: 152.72,
                              Y201210: 152.72,
                              Y201211: 152.72,
                              Y201212: 152.72,
                              Y201301: 152.72,
                              Y201302: 152.72,
                              Y201303: 152.72,
                              Y201304: 152.72,
                              Y201305: 152.72,
                              Y201306: 152.72,
                              Y201307: 152.72,
                              Y201308: 152.72
                            }
                          ]
                        },
                        {
                          Cls: '의복관련장신품',
                          Y201208: 116.92,
                          Y201209: 117.88,
                          Y201210: 117.88,
                          Y201211: 117.88,
                          Y201212: 117.88,
                          Y201301: 117.88,
                          Y201302: 118.85,
                          Y201303: 118.85,
                          Y201304: 118.85,
                          Y201305: 118.85,
                          Y201306: 118.85,
                          Y201307: 118.85,
                          Y201308: 119.13,
                          Items: [
                            {
                              Cls: '의복관련장신품',
                              Y201208: 116.92,
                              Y201209: 117.88,
                              Y201210: 117.88,
                              Y201211: 117.88,
                              Y201212: 117.88,
                              Y201301: 117.88,
                              Y201302: 118.85,
                              Y201303: 118.85,
                              Y201304: 118.85,
                              Y201305: 118.85,
                              Y201306: 118.85,
                              Y201307: 118.85,
                              Y201308: 119.13
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '가죽제품',
                      Y201208: 102.29,
                      Y201209: 102.56,
                      Y201210: 101.51,
                      Y201211: 101.27,
                      Y201212: 101.14,
                      Y201301: 100.91,
                      Y201302: 101.18,
                      Y201303: 101.25,
                      Y201304: 101.35,
                      Y201305: 102.26,
                      Y201306: 102.26,
                      Y201307: 102.26,
                      Y201308: 102.82,
                      Items: [
                        {
                          Cls: '가죽및모피',
                          Y201208: 104.37,
                          Y201209: 104.05,
                          Y201210: 103.22,
                          Y201211: 102.31,
                          Y201212: 101.81,
                          Y201301: 105.32,
                          Y201302: 106.64,
                          Y201303: 107.01,
                          Y201304: 107.49,
                          Y201305: 110.06,
                          Y201306: 110.06,
                          Y201307: 110.06,
                          Y201308: 110.06,
                          Items: [
                            {
                              Cls: '가죽',
                              Y201208: 104.37,
                              Y201209: 104.05,
                              Y201210: 103.22,
                              Y201211: 102.31,
                              Y201212: 101.81,
                              Y201301: 105.32,
                              Y201302: 106.64,
                              Y201303: 107.01,
                              Y201304: 107.49,
                              Y201305: 110.06,
                              Y201306: 110.06,
                              Y201307: 110.06,
                              Y201308: 110.06
                            }
                          ]
                        },
                        {
                          Cls: '가방및신발',
                          Y201208: 101.74,
                          Y201209: 102.24,
                          Y201210: 101.11,
                          Y201211: 101.11,
                          Y201212: 101.11,
                          Y201301: 99.90,
                          Y201302: 99.90,
                          Y201303: 99.90,
                          Y201304: 99.90,
                          Y201305: 100.37,
                          Y201306: 100.37,
                          Y201307: 100.37,
                          Y201308: 101.07,
                          Items: [
                            {
                              Cls: '가방및핸드백',
                              Y201208: 103.30,
                              Y201209: 103.33,
                              Y201210: 103.33,
                              Y201211: 103.33,
                              Y201212: 103.33,
                              Y201301: 103.32,
                              Y201302: 103.32,
                              Y201303: 103.32,
                              Y201304: 103.32,
                              Y201305: 103.37,
                              Y201306: 103.37,
                              Y201307: 103.37,
                              Y201308: 103.37
                            },
                            {
                              Cls: '신발',
                              Y201208: 100.71,
                              Y201209: 101.41,
                              Y201210: 99.80,
                              Y201211: 99.80,
                              Y201212: 99.80,
                              Y201301: 97.91,
                              Y201302: 97.91,
                              Y201303: 97.91,
                              Y201304: 97.91,
                              Y201305: 98.62,
                              Y201306: 98.62,
                              Y201307: 98.62,
                              Y201308: 99.72
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '목재및종이제품',
                  Y201208: 107.95,
                  Y201209: 107.67,
                  Y201210: 107.43,
                  Y201211: 107.31,
                  Y201212: 105.19,
                  Y201301: 105.12,
                  Y201302: 105.20,
                  Y201303: 104.79,
                  Y201304: 105.20,
                  Y201305: 105.31,
                  Y201306: 105.30,
                  Y201307: 105.23,
                  Y201308: 105.19,
                  Items: [
                    {
                      Cls: '목재및목제품',
                      Y201208: 111.08,
                      Y201209: 110.38,
                      Y201210: 110.06,
                      Y201211: 109.85,
                      Y201212: 109.53,
                      Y201301: 109.38,
                      Y201302: 109.48,
                      Y201303: 110.09,
                      Y201304: 110.83,
                      Y201305: 111.41,
                      Y201306: 111.51,
                      Y201307: 111.73,
                      Y201308: 111.85,
                      Items: [
                        {
                          Cls: '목재',
                          Y201208: 116.93,
                          Y201209: 115.10,
                          Y201210: 114.53,
                          Y201211: 114.19,
                          Y201212: 113.64,
                          Y201301: 113.36,
                          Y201302: 113.62,
                          Y201303: 114.74,
                          Y201304: 116.12,
                          Y201305: 117.19,
                          Y201306: 117.36,
                          Y201307: 117.78,
                          Y201308: 117.98,
                          Items: [
                            {
                              Cls: '제재목',
                              Y201208: 129.35,
                              Y201209: 129.35,
                              Y201210: 129.35,
                              Y201211: 129.35,
                              Y201212: 128.96,
                              Y201301: 127.83,
                              Y201302: 128.37,
                              Y201303: 130.15,
                              Y201304: 131.67,
                              Y201305: 132.74,
                              Y201306: 132.88,
                              Y201307: 133.91,
                              Y201308: 133.91
                            },
                            {
                              Cls: '합판',
                              Y201208: 112.46,
                              Y201209: 107.02,
                              Y201210: 105.70,
                              Y201211: 105.70,
                              Y201212: 104.05,
                              Y201301: 105.39,
                              Y201302: 105.39,
                              Y201303: 105.39,
                              Y201304: 105.39,
                              Y201305: 105.39,
                              Y201306: 105.94,
                              Y201307: 105.52,
                              Y201308: 106.68
                            },
                            {
                              Cls: '강화및재생목재',
                              Y201208: 102.33,
                              Y201209: 100.12,
                              Y201210: 99.16,
                              Y201211: 97.94,
                              Y201212: 97.94,
                              Y201301: 97.94,
                              Y201302: 97.94,
                              Y201303: 98.76,
                              Y201304: 100.82,
                              Y201305: 102.56,
                              Y201306: 102.56,
                              Y201307: 102.56,
                              Y201308: 102.49
                            }
                          ]
                        },
                        {
                          Cls: '목제품',
                          Y201208: 102.80,
                          Y201209: 103.63,
                          Y201210: 103.63,
                          Y201211: 103.63,
                          Y201212: 103.63,
                          Y201301: 103.63,
                          Y201302: 103.54,
                          Y201303: 103.54,
                          Y201304: 103.54,
                          Y201305: 103.54,
                          Y201306: 103.54,
                          Y201307: 103.54,
                          Y201308: 103.54,
                          Items: [
                            {
                              Cls: '건축용목제품',
                              Y201208: 102.80,
                              Y201209: 104.59,
                              Y201210: 104.59,
                              Y201211: 104.59,
                              Y201212: 104.59,
                              Y201301: 104.59,
                              Y201302: 104.59,
                              Y201303: 104.59,
                              Y201304: 104.60,
                              Y201305: 104.60,
                              Y201306: 104.60,
                              Y201307: 104.60,
                              Y201308: 104.60
                            },
                            {
                              Cls: '목재용기및적재판',
                              Y201208: 103.30,
                              Y201209: 103.30,
                              Y201210: 103.30,
                              Y201211: 103.30,
                              Y201212: 103.30,
                              Y201301: 103.30,
                              Y201302: 103.15,
                              Y201303: 103.15,
                              Y201304: 103.15,
                              Y201305: 103.15,
                              Y201306: 103.15,
                              Y201307: 103.15,
                              Y201308: 103.15
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '펄프및종이제품',
                      Y201208: 107.16,
                      Y201209: 107.01,
                      Y201210: 106.80,
                      Y201211: 106.70,
                      Y201212: 104.01,
                      Y201301: 103.97,
                      Y201302: 104.04,
                      Y201303: 103.32,
                      Y201304: 103.64,
                      Y201305: 103.59,
                      Y201306: 103.55,
                      Y201307: 103.40,
                      Y201308: 103.31,
                      Items: [
                        {
                          Cls: '펄프',
                          Y201208: 83.82,
                          Y201209: 83.38,
                          Y201210: 83.38,
                          Y201211: 81.18,
                          Y201212: 80.40,
                          Y201301: 79.53,
                          Y201302: 84.29,
                          Y201303: 89.36,
                          Y201304: 90.95,
                          Y201305: 90.04,
                          Y201306: 92.03,
                          Y201307: 88.75,
                          Y201308: 86.65,
                          Items: [
                            {
                              Cls: '펄프',
                              Y201208: 83.82,
                              Y201209: 83.38,
                              Y201210: 83.38,
                              Y201211: 81.18,
                              Y201212: 80.40,
                              Y201301: 79.53,
                              Y201302: 84.29,
                              Y201303: 89.36,
                              Y201304: 90.95,
                              Y201305: 90.04,
                              Y201306: 92.03,
                              Y201307: 88.75,
                              Y201308: 86.65
                            }
                          ]
                        },
                        {
                          Cls: '종이류',
                          Y201208: 103.03,
                          Y201209: 102.70,
                          Y201210: 102.22,
                          Y201211: 102.12,
                          Y201212: 102.24,
                          Y201301: 102.20,
                          Y201302: 102.20,
                          Y201303: 100.33,
                          Y201304: 100.76,
                          Y201305: 100.72,
                          Y201306: 100.55,
                          Y201307: 100.32,
                          Y201308: 100.35,
                          Items: [
                            {
                              Cls: '인쇄용지',
                              Y201208: 98.76,
                              Y201209: 98.77,
                              Y201210: 98.72,
                              Y201211: 98.37,
                              Y201212: 99.51,
                              Y201301: 99.51,
                              Y201302: 99.51,
                              Y201303: 99.51,
                              Y201304: 100.84,
                              Y201305: 100.83,
                              Y201306: 101.11,
                              Y201307: 101.34,
                              Y201308: 101.33
                            },
                            {
                              Cls: '기타원지및판지',
                              Y201208: 105.64,
                              Y201209: 105.14,
                              Y201210: 104.45,
                              Y201211: 104.45,
                              Y201212: 104.08,
                              Y201301: 104.02,
                              Y201302: 104.02,
                              Y201303: 100.98,
                              Y201304: 100.84,
                              Y201305: 100.78,
                              Y201306: 100.35,
                              Y201307: 99.83,
                              Y201308: 99.88
                            }
                          ]
                        },
                        {
                          Cls: '종이제품',
                          Y201208: 112.15,
                          Y201209: 112.15,
                          Y201210: 112.14,
                          Y201211: 112.12,
                          Y201212: 107.13,
                          Y201301: 107.11,
                          Y201302: 107.08,
                          Y201303: 107.01,
                          Y201304: 107.18,
                          Y201305: 107.18,
                          Y201306: 107.14,
                          Y201307: 107.17,
                          Y201308: 107.09,
                          Items: [
                            {
                              Cls: '골판지및골판지상자',
                              Y201208: 119.71,
                              Y201209: 119.71,
                              Y201210: 119.71,
                              Y201211: 119.71,
                              Y201212: 109.55,
                              Y201301: 109.55,
                              Y201302: 109.55,
                              Y201303: 109.55,
                              Y201304: 109.55,
                              Y201305: 109.55,
                              Y201306: 109.55,
                              Y201307: 109.55,
                              Y201308: 109.55
                            },
                            {
                              Cls: '종이용기',
                              Y201208: 106.02,
                              Y201209: 106.00,
                              Y201210: 105.94,
                              Y201211: 105.83,
                              Y201212: 105.70,
                              Y201301: 105.59,
                              Y201302: 105.37,
                              Y201303: 105.59,
                              Y201304: 105.95,
                              Y201305: 106.17,
                              Y201306: 106.09,
                              Y201307: 106.28,
                              Y201308: 106.40
                            },
                            {
                              Cls: '종이문구및사무용지',
                              Y201208: 108.80,
                              Y201209: 108.80,
                              Y201210: 108.80,
                              Y201211: 108.80,
                              Y201212: 108.80,
                              Y201301: 108.80,
                              Y201302: 108.80,
                              Y201303: 108.97,
                              Y201304: 110.85,
                              Y201305: 110.85,
                              Y201306: 110.97,
                              Y201307: 110.97,
                              Y201308: 110.97
                            },
                            {
                              Cls: '위생용종이제품',
                              Y201208: 105.66,
                              Y201209: 105.66,
                              Y201210: 105.66,
                              Y201211: 105.66,
                              Y201212: 105.66,
                              Y201301: 105.66,
                              Y201302: 105.66,
                              Y201303: 105.04,
                              Y201304: 105.04,
                              Y201305: 105.04,
                              Y201306: 104.85,
                              Y201307: 104.85,
                              Y201308: 104.27
                            },
                            {
                              Cls: '기타종이제품',
                              Y201208: 106.16,
                              Y201209: 106.16,
                              Y201210: 106.16,
                              Y201211: 106.16,
                              Y201212: 106.16,
                              Y201301: 106.16,
                              Y201302: 106.16,
                              Y201303: 106.16,
                              Y201304: 105.66,
                              Y201305: 105.16,
                              Y201306: 105.16,
                              Y201307: 105.16,
                              Y201308: 105.16
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '석탄및석유제품',
                  Y201208: 128.98,
                  Y201209: 132.66,
                  Y201210: 129.78,
                  Y201211: 125.84,
                  Y201212: 124.28,
                  Y201301: 124.39,
                  Y201302: 129.92,
                  Y201303: 125.92,
                  Y201304: 122.19,
                  Y201305: 120.56,
                  Y201306: 121.84,
                  Y201307: 123.96,
                  Y201308: 123.96,
                  Items: [
                    {
                      Cls: '석탄제품',
                      Y201208: 121.10,
                      Y201209: 121.10,
                      Y201210: 121.10,
                      Y201211: 121.10,
                      Y201212: 121.10,
                      Y201301: 126.34,
                      Y201302: 126.34,
                      Y201303: 126.34,
                      Y201304: 126.34,
                      Y201305: 126.34,
                      Y201306: 126.34,
                      Y201307: 120.87,
                      Y201308: 120.87,
                      Items: [
                        {
                          Cls: '석탄제품',
                          Y201208: 121.10,
                          Y201209: 121.10,
                          Y201210: 121.10,
                          Y201211: 121.10,
                          Y201212: 121.10,
                          Y201301: 126.34,
                          Y201302: 126.34,
                          Y201303: 126.34,
                          Y201304: 126.34,
                          Y201305: 126.34,
                          Y201306: 126.34,
                          Y201307: 120.87,
                          Y201308: 120.87,
                          Items: [
                            {
                              Cls: '석탄코크스및석탄관련제품',
                              Y201208: 123.60,
                              Y201209: 123.60,
                              Y201210: 123.60,
                              Y201211: 123.60,
                              Y201212: 123.60,
                              Y201301: 129.14,
                              Y201302: 129.14,
                              Y201303: 129.14,
                              Y201304: 129.14,
                              Y201305: 129.14,
                              Y201306: 129.14,
                              Y201307: 123.35,
                              Y201308: 123.35
                            },
                            {
                              Cls: '연탄',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 100.00,
                              Y201301: 100.00,
                              Y201302: 100.00,
                              Y201303: 100.00,
                              Y201304: 100.00,
                              Y201305: 100.00,
                              Y201306: 100.00,
                              Y201307: 100.00,
                              Y201308: 100.00
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '석유제품',
                      Y201208: 131.55,
                      Y201209: 135.57,
                      Y201210: 132.43,
                      Y201211: 128.14,
                      Y201212: 126.44,
                      Y201301: 125.93,
                      Y201302: 132.21,
                      Y201303: 127.67,
                      Y201304: 123.44,
                      Y201305: 121.58,
                      Y201306: 123.04,
                      Y201307: 126.10,
                      Y201308: 126.11,
                      Items: [
                        {
                          Cls: '연료유',
                          Y201208: 131.71,
                          Y201209: 135.94,
                          Y201210: 132.31,
                          Y201211: 127.72,
                          Y201212: 125.98,
                          Y201301: 125.80,
                          Y201302: 132.69,
                          Y201303: 127.50,
                          Y201304: 122.67,
                          Y201305: 120.68,
                          Y201306: 122.53,
                          Y201307: 126.08,
                          Y201308: 125.94,
                          Items: [
                            {
                              Cls: '나프타',
                              Y201208: 125.72,
                              Y201209: 130.08,
                              Y201210: 126.07,
                              Y201211: 121.30,
                              Y201212: 121.08,
                              Y201301: 121.62,
                              Y201302: 126.86,
                              Y201303: 121.15,
                              Y201304: 113.94,
                              Y201305: 113.11,
                              Y201306: 116.79,
                              Y201307: 119.83,
                              Y201308: 123.13
                            },
                            {
                              Cls: '휘발유',
                              Y201208: 136.27,
                              Y201209: 136.07,
                              Y201210: 130.42,
                              Y201211: 125.11,
                              Y201212: 125.30,
                              Y201301: 126.74,
                              Y201302: 139.16,
                              Y201303: 132.05,
                              Y201304: 124.70,
                              Y201305: 122.14,
                              Y201306: 126.29,
                              Y201307: 131.26,
                              Y201308: 125.50
                            },
                            {
                              Cls: '제트유',
                              Y201208: 129.80,
                              Y201209: 141.06,
                              Y201210: 143.49,
                              Y201211: 138.85,
                              Y201212: 131.42,
                              Y201301: 129.67,
                              Y201302: 131.59,
                              Y201303: 131.41,
                              Y201304: 131.41,
                              Y201305: 126.04,
                              Y201306: 128.02,
                              Y201307: 131.77,
                              Y201308: 134.31
                            },
                            {
                              Cls: '등유',
                              Y201208: 138.66,
                              Y201209: 145.11,
                              Y201210: 138.51,
                              Y201211: 132.87,
                              Y201212: 131.58,
                              Y201301: 132.87,
                              Y201302: 142.53,
                              Y201303: 133.28,
                              Y201304: 127.74,
                              Y201305: 123.90,
                              Y201306: 127.42,
                              Y201307: 132.17,
                              Y201308: 132.83
                            },
                            {
                              Cls: '경유',
                              Y201208: 136.09,
                              Y201209: 141.17,
                              Y201210: 133.11,
                              Y201211: 129.55,
                              Y201212: 129.11,
                              Y201301: 128.06,
                              Y201302: 137.30,
                              Y201303: 127.74,
                              Y201304: 123.26,
                              Y201305: 121.57,
                              Y201306: 123.12,
                              Y201307: 126.88,
                              Y201308: 126.19
                            },
                            {
                              Cls: '중유',
                              Y201208: 137.23,
                              Y201209: 141.70,
                              Y201210: 142.84,
                              Y201211: 135.16,
                              Y201212: 127.65,
                              Y201301: 125.94,
                              Y201302: 127.43,
                              Y201303: 135.07,
                              Y201304: 133.92,
                              Y201305: 132.46,
                              Y201306: 129.76,
                              Y201307: 133.14,
                              Y201308: 130.96
                            },
                            {
                              Cls: '액화석유가스',
                              Y201208: 117.51,
                              Y201209: 117.51,
                              Y201210: 125.32,
                              Y201211: 126.99,
                              Y201212: 126.92,
                              Y201301: 126.92,
                              Y201302: 126.74,
                              Y201303: 125.08,
                              Y201304: 125.12,
                              Y201305: 120.56,
                              Y201306: 117.41,
                              Y201307: 117.41,
                              Y201308: 121.27
                            }
                          ]
                        },
                        {
                          Cls: '기타석유제품',
                          Y201208: 128.99,
                          Y201209: 131.12,
                          Y201210: 132.53,
                          Y201211: 130.82,
                          Y201212: 129.61,
                          Y201301: 126.29,
                          Y201302: 127.26,
                          Y201303: 128.29,
                          Y201304: 129.31,
                          Y201305: 128.61,
                          Y201306: 126.71,
                          Y201307: 125.58,
                          Y201308: 126.76,
                          Items: [
                            {
                              Cls: '윤활유및그리스',
                              Y201208: 126.81,
                              Y201209: 126.35,
                              Y201210: 126.35,
                              Y201211: 126.35,
                              Y201212: 126.35,
                              Y201301: 120.84,
                              Y201302: 120.84,
                              Y201303: 119.38,
                              Y201304: 121.69,
                              Y201305: 122.29,
                              Y201306: 122.29,
                              Y201307: 122.29,
                              Y201308: 122.29
                            },
                            {
                              Cls: '기타석유정제제품',
                              Y201208: 130.30,
                              Y201209: 134.11,
                              Y201210: 136.44,
                              Y201211: 133.61,
                              Y201212: 131.61,
                              Y201301: 130.00,
                              Y201302: 131.74,
                              Y201303: 134.72,
                              Y201304: 134.72,
                              Y201305: 132.99,
                              Y201306: 129.61,
                              Y201307: 127.61,
                              Y201308: 129.71
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '화학제품',
                  Y201208: 110.49,
                  Y201209: 112.26,
                  Y201210: 112.31,
                  Y201211: 111.11,
                  Y201212: 110.87,
                  Y201301: 111.39,
                  Y201302: 112.63,
                  Y201303: 112.16,
                  Y201304: 110.88,
                  Y201305: 109.81,
                  Y201306: 110.03,
                  Y201307: 110.16,
                  Y201308: 110.88,
                  Items: [
                    {
                      Cls: '기초화학제품',
                      Y201208: 117.05,
                      Y201209: 121.75,
                      Y201210: 121.78,
                      Y201211: 118.69,
                      Y201212: 118.13,
                      Y201301: 120.10,
                      Y201302: 123.34,
                      Y201303: 121.72,
                      Y201304: 118.12,
                      Y201305: 115.79,
                      Y201306: 116.77,
                      Y201307: 116.96,
                      Y201308: 118.72,
                      Items: [
                        {
                          Cls: '석유화학기초제품',
                          Y201208: 118.86,
                          Y201209: 124.34,
                          Y201210: 124.55,
                          Y201211: 121.19,
                          Y201212: 120.75,
                          Y201301: 123.09,
                          Y201302: 126.74,
                          Y201303: 124.59,
                          Y201304: 120.27,
                          Y201305: 117.68,
                          Y201306: 118.85,
                          Y201307: 118.97,
                          Y201308: 121.21,
                          Items: [
                            {
                              Cls: '지방족기초유분',
                              Y201208: 122.25,
                              Y201209: 128.32,
                              Y201210: 126.81,
                              Y201211: 120.99,
                              Y201212: 117.41,
                              Y201301: 117.20,
                              Y201302: 124.14,
                              Y201303: 124.62,
                              Y201304: 119.70,
                              Y201305: 115.04,
                              Y201306: 116.47,
                              Y201307: 115.86,
                              Y201308: 118.54
                            },
                            {
                              Cls: '방향족기초유분',
                              Y201208: 125.21,
                              Y201209: 131.54,
                              Y201210: 134.48,
                              Y201211: 134.01,
                              Y201212: 137.38,
                              Y201301: 142.64,
                              Y201302: 141.53,
                              Y201303: 135.87,
                              Y201304: 131.39,
                              Y201305: 131.69,
                              Y201306: 131.21,
                              Y201307: 132.32,
                              Y201308: 135.20
                            },
                            {
                              Cls: '석유화학중간제품',
                              Y201208: 106.23,
                              Y201209: 109.88,
                              Y201210: 110.15,
                              Y201211: 107.93,
                              Y201212: 108.80,
                              Y201301: 112.34,
                              Y201302: 115.84,
                              Y201303: 113.12,
                              Y201304: 110.01,
                              Y201305: 107.66,
                              Y201306: 110.42,
                              Y201307: 110.66,
                              Y201308: 111.36
                            }
                          ]
                        },
                        {
                          Cls: '기타유기화학기초제품',
                          Y201208: 97.98,
                          Y201209: 100.18,
                          Y201210: 99.30,
                          Y201211: 96.27,
                          Y201212: 95.31,
                          Y201301: 96.15,
                          Y201302: 99.64,
                          Y201303: 100.90,
                          Y201304: 98.66,
                          Y201305: 95.49,
                          Y201306: 95.77,
                          Y201307: 96.37,
                          Y201308: 95.08,
                          Items: [
                            {
                              Cls: '기타기초유기화합물',
                              Y201208: 97.98,
                              Y201209: 100.18,
                              Y201210: 99.30,
                              Y201211: 96.27,
                              Y201212: 95.31,
                              Y201301: 96.15,
                              Y201302: 99.64,
                              Y201303: 100.90,
                              Y201304: 98.66,
                              Y201305: 95.49,
                              Y201306: 95.77,
                              Y201307: 96.37,
                              Y201308: 95.08
                            }
                          ]
                        },
                        {
                          Cls: '무기화학기초제품',
                          Y201208: 118.82,
                          Y201209: 119.22,
                          Y201210: 118.75,
                          Y201211: 117.75,
                          Y201212: 116.64,
                          Y201301: 116.86,
                          Y201302: 116.70,
                          Y201303: 116.21,
                          Y201304: 116.74,
                          Y201305: 117.20,
                          Y201306: 117.54,
                          Y201307: 117.75,
                          Y201308: 119.05,
                          Items: [
                            {
                              Cls: '산업용가스',
                              Y201208: 118.09,
                              Y201209: 118.97,
                              Y201210: 118.12,
                              Y201211: 116.94,
                              Y201212: 117.30,
                              Y201301: 117.16,
                              Y201302: 118.20,
                              Y201303: 116.49,
                              Y201304: 115.62,
                              Y201305: 115.41,
                              Y201306: 116.01,
                              Y201307: 115.88,
                              Y201308: 116.29
                            },
                            {
                              Cls: '기초무기화합물',
                              Y201208: 125.91,
                              Y201209: 125.89,
                              Y201210: 125.89,
                              Y201211: 124.81,
                              Y201212: 122.40,
                              Y201301: 123.37,
                              Y201302: 122.12,
                              Y201303: 122.12,
                              Y201304: 123.83,
                              Y201305: 125.18,
                              Y201306: 125.46,
                              Y201307: 125.81,
                              Y201308: 125.45
                            },
                            {
                              Cls: '염료,안료및유연제',
                              Y201208: 107.24,
                              Y201209: 107.59,
                              Y201210: 106.98,
                              Y201211: 106.31,
                              Y201212: 105.22,
                              Y201301: 104.91,
                              Y201302: 104.74,
                              Y201303: 105.04,
                              Y201304: 105.69,
                              Y201305: 105.78,
                              Y201306: 105.91,
                              Y201307: 106.31,
                              Y201308: 110.67
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '합성수지및합성고무',
                      Y201208: 111.38,
                      Y201209: 112.23,
                      Y201210: 112.39,
                      Y201211: 111.71,
                      Y201212: 110.92,
                      Y201301: 110.79,
                      Y201302: 112.76,
                      Y201303: 113.06,
                      Y201304: 112.89,
                      Y201305: 111.25,
                      Y201306: 111.60,
                      Y201307: 112.67,
                      Y201308: 112.91,
                      Items: [
                        {
                          Cls: '합성수지및합성고무',
                          Y201208: 111.38,
                          Y201209: 112.23,
                          Y201210: 112.39,
                          Y201211: 111.71,
                          Y201212: 110.92,
                          Y201301: 110.79,
                          Y201302: 112.76,
                          Y201303: 113.06,
                          Y201304: 112.89,
                          Y201305: 111.25,
                          Y201306: 111.60,
                          Y201307: 112.67,
                          Y201308: 112.91,
                          Items: [
                            {
                              Cls: '합성수지',
                              Y201208: 110.53,
                              Y201209: 111.94,
                              Y201210: 112.17,
                              Y201211: 111.55,
                              Y201212: 110.96,
                              Y201301: 110.99,
                              Y201302: 112.90,
                              Y201303: 113.25,
                              Y201304: 112.98,
                              Y201305: 111.57,
                              Y201306: 112.03,
                              Y201307: 113.38,
                              Y201308: 113.58
                            },
                            {
                              Cls: '합성고무',
                              Y201208: 124.37,
                              Y201209: 115.79,
                              Y201210: 114.56,
                              Y201211: 113.05,
                              Y201212: 108.67,
                              Y201301: 103.23,
                              Y201302: 107.63,
                              Y201303: 106.29,
                              Y201304: 109.14,
                              Y201305: 100.57,
                              Y201306: 97.15,
                              Y201307: 89.64,
                              Y201308: 90.71
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '화학섬유',
                      Y201208: 103.14,
                      Y201209: 104.07,
                      Y201210: 104.17,
                      Y201211: 102.58,
                      Y201212: 102.33,
                      Y201301: 104.34,
                      Y201302: 106.85,
                      Y201303: 107.22,
                      Y201304: 107.70,
                      Y201305: 106.72,
                      Y201306: 106.72,
                      Y201307: 103.64,
                      Y201308: 102.80,
                      Items: [
                        {
                          Cls: '화학섬유',
                          Y201208: 103.14,
                          Y201209: 104.07,
                          Y201210: 104.17,
                          Y201211: 102.58,
                          Y201212: 102.33,
                          Y201301: 104.34,
                          Y201302: 106.85,
                          Y201303: 107.22,
                          Y201304: 107.70,
                          Y201305: 106.72,
                          Y201306: 106.72,
                          Y201307: 103.64,
                          Y201308: 102.80,
                          Items: [
                            {
                              Cls: '화학섬유',
                              Y201208: 103.14,
                              Y201209: 104.07,
                              Y201210: 104.17,
                              Y201211: 102.58,
                              Y201212: 102.33,
                              Y201301: 104.34,
                              Y201302: 106.85,
                              Y201303: 107.22,
                              Y201304: 107.70,
                              Y201305: 106.72,
                              Y201306: 106.72,
                              Y201307: 103.64,
                              Y201308: 102.80
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '의약품',
                      Y201208: 96.03,
                      Y201209: 96.03,
                      Y201210: 96.03,
                      Y201211: 96.03,
                      Y201212: 96.38,
                      Y201301: 96.02,
                      Y201302: 96.04,
                      Y201303: 96.04,
                      Y201304: 96.04,
                      Y201305: 95.89,
                      Y201306: 95.89,
                      Y201307: 95.84,
                      Y201308: 95.84,
                      Items: [
                        {
                          Cls: '의약품',
                          Y201208: 96.03,
                          Y201209: 96.03,
                          Y201210: 96.03,
                          Y201211: 96.03,
                          Y201212: 96.38,
                          Y201301: 96.02,
                          Y201302: 96.04,
                          Y201303: 96.04,
                          Y201304: 96.04,
                          Y201305: 95.89,
                          Y201306: 95.89,
                          Y201307: 95.84,
                          Y201308: 95.84,
                          Items: [
                            {
                              Cls: '의약품',
                              Y201208: 96.03,
                              Y201209: 96.03,
                              Y201210: 96.03,
                              Y201211: 96.03,
                              Y201212: 96.38,
                              Y201301: 96.02,
                              Y201302: 96.04,
                              Y201303: 96.04,
                              Y201304: 96.04,
                              Y201305: 95.89,
                              Y201306: 95.89,
                              Y201307: 95.84,
                              Y201308: 95.84
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '기타최종화학제품',
                      Y201208: 106.44,
                      Y201209: 107.03,
                      Y201210: 106.96,
                      Y201211: 106.90,
                      Y201212: 106.89,
                      Y201301: 106.96,
                      Y201302: 106.24,
                      Y201303: 106.16,
                      Y201304: 105.81,
                      Y201305: 105.37,
                      Y201306: 105.12,
                      Y201307: 104.97,
                      Y201308: 105.54,
                      Items: [
                        {
                          Cls: '비료및농약',
                          Y201208: 102.86,
                          Y201209: 102.86,
                          Y201210: 102.86,
                          Y201211: 102.86,
                          Y201212: 102.86,
                          Y201301: 103.66,
                          Y201302: 103.66,
                          Y201303: 103.66,
                          Y201304: 103.66,
                          Y201305: 103.66,
                          Y201306: 103.66,
                          Y201307: 103.66,
                          Y201308: 103.66,
                          Items: [
                            {
                              Cls: '비료및질소화합물',
                              Y201208: 103.83,
                              Y201209: 103.83,
                              Y201210: 103.83,
                              Y201211: 103.83,
                              Y201212: 103.83,
                              Y201301: 104.97,
                              Y201302: 104.97,
                              Y201303: 104.97,
                              Y201304: 104.97,
                              Y201305: 104.97,
                              Y201306: 104.97,
                              Y201307: 104.97,
                              Y201308: 104.97
                            },
                            {
                              Cls: '살충제및농약',
                              Y201208: 101.28,
                              Y201209: 101.28,
                              Y201210: 101.28,
                              Y201211: 101.28,
                              Y201212: 101.28,
                              Y201301: 101.28,
                              Y201302: 101.28,
                              Y201303: 101.28,
                              Y201304: 101.28,
                              Y201305: 101.28,
                              Y201306: 101.28,
                              Y201307: 101.28,
                              Y201308: 101.28
                            }
                          ]
                        },
                        {
                          Cls: '도료및잉크',
                          Y201208: 110.20,
                          Y201209: 110.20,
                          Y201210: 110.20,
                          Y201211: 110.20,
                          Y201212: 110.20,
                          Y201301: 110.20,
                          Y201302: 110.20,
                          Y201303: 110.20,
                          Y201304: 110.20,
                          Y201305: 110.20,
                          Y201306: 110.20,
                          Y201307: 110.20,
                          Y201308: 110.20,
                          Items: [
                            {
                              Cls: '도료',
                              Y201208: 110.13,
                              Y201209: 110.13,
                              Y201210: 110.13,
                              Y201211: 110.13,
                              Y201212: 110.13,
                              Y201301: 110.13,
                              Y201302: 110.13,
                              Y201303: 110.13,
                              Y201304: 110.13,
                              Y201305: 110.13,
                              Y201306: 110.13,
                              Y201307: 110.13,
                              Y201308: 110.13
                            },
                            {
                              Cls: '잉크',
                              Y201208: 111.05,
                              Y201209: 111.05,
                              Y201210: 111.05,
                              Y201211: 111.05,
                              Y201212: 111.05,
                              Y201301: 111.05,
                              Y201302: 111.05,
                              Y201303: 111.05,
                              Y201304: 111.05,
                              Y201305: 111.05,
                              Y201306: 111.05,
                              Y201307: 111.05,
                              Y201308: 111.05
                            }
                          ]
                        },
                        {
                          Cls: '비누및화장품',
                          Y201208: 99.99,
                          Y201209: 101.80,
                          Y201210: 102.03,
                          Y201211: 101.89,
                          Y201212: 102.02,
                          Y201301: 102.46,
                          Y201302: 102.50,
                          Y201303: 102.29,
                          Y201304: 102.10,
                          Y201305: 102.18,
                          Y201306: 102.34,
                          Y201307: 102.39,
                          Y201308: 102.79,
                          Items: [
                            {
                              Cls: '비누,세제및치약',
                              Y201208: 107.27,
                              Y201209: 107.87,
                              Y201210: 107.99,
                              Y201211: 107.63,
                              Y201212: 107.68,
                              Y201301: 108.07,
                              Y201302: 108.20,
                              Y201303: 107.58,
                              Y201304: 107.38,
                              Y201305: 107.60,
                              Y201306: 107.55,
                              Y201307: 107.68,
                              Y201308: 108.80
                            },
                            {
                              Cls: '화장품',
                              Y201208: 95.07,
                              Y201209: 97.73,
                              Y201210: 98.04,
                              Y201211: 98.04,
                              Y201212: 98.22,
                              Y201301: 98.68,
                              Y201302: 98.68,
                              Y201303: 98.68,
                              Y201304: 98.52,
                              Y201305: 98.52,
                              Y201306: 98.78,
                              Y201307: 98.78,
                              Y201308: 98.78
                            }
                          ]
                        },
                        {
                          Cls: '기타화학제품',
                          Y201208: 110.64,
                          Y201209: 110.90,
                          Y201210: 110.55,
                          Y201211: 110.48,
                          Y201212: 110.36,
                          Y201301: 110.01,
                          Y201302: 108.22,
                          Y201303: 108.16,
                          Y201304: 107.40,
                          Y201305: 106.31,
                          Y201306: 105.59,
                          Y201307: 105.21,
                          Y201308: 106.35,
                          Items: [
                            {
                              Cls: '접착제및젤라틴',
                              Y201208: 111.53,
                              Y201209: 111.53,
                              Y201210: 111.53,
                              Y201211: 111.53,
                              Y201212: 111.53,
                              Y201301: 111.53,
                              Y201302: 108.63,
                              Y201303: 108.63,
                              Y201304: 108.63,
                              Y201305: 108.63,
                              Y201306: 107.16,
                              Y201307: 107.16,
                              Y201308: 107.16
                            },
                            {
                              Cls: '사진용화학제품 및 감광재료',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 100.00,
                              Y201301: 100.00,
                              Y201302: 100.00,
                              Y201303: 100.00,
                              Y201304: 100.00,
                              Y201305: 99.34,
                              Y201306: 99.34,
                              Y201307: 99.34,
                              Y201308: 99.34
                            },
                            {
                              Cls: '기타화학제품',
                              Y201208: 111.38,
                              Y201209: 111.72,
                              Y201210: 111.27,
                              Y201211: 111.19,
                              Y201212: 111.04,
                              Y201301: 110.57,
                              Y201302: 108.89,
                              Y201303: 108.82,
                              Y201304: 107.82,
                              Y201305: 106.45,
                              Y201306: 105.84,
                              Y201307: 105.33,
                              Y201308: 106.84
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '플라스틱제품',
                      Y201208: 107.74,
                      Y201209: 107.31,
                      Y201210: 107.44,
                      Y201211: 107.53,
                      Y201212: 107.56,
                      Y201301: 106.97,
                      Y201302: 107.05,
                      Y201303: 107.30,
                      Y201304: 107.39,
                      Y201305: 107.28,
                      Y201306: 106.89,
                      Y201307: 107.10,
                      Y201308: 107.15,
                      Items: [
                        {
                          Cls: '플라스틱제품',
                          Y201208: 107.74,
                          Y201209: 107.31,
                          Y201210: 107.44,
                          Y201211: 107.53,
                          Y201212: 107.56,
                          Y201301: 106.97,
                          Y201302: 107.05,
                          Y201303: 107.30,
                          Y201304: 107.39,
                          Y201305: 107.28,
                          Y201306: 106.89,
                          Y201307: 107.10,
                          Y201308: 107.15,
                          Items: [
                            {
                              Cls: '플라스틱1차제품',
                              Y201208: 106.40,
                              Y201209: 106.40,
                              Y201210: 106.34,
                              Y201211: 106.22,
                              Y201212: 105.90,
                              Y201301: 105.86,
                              Y201302: 105.16,
                              Y201303: 105.58,
                              Y201304: 105.28,
                              Y201305: 105.28,
                              Y201306: 105.36,
                              Y201307: 105.37,
                              Y201308: 105.24
                            },
                            {
                              Cls: '건축용플라스틱제품',
                              Y201208: 118.31,
                              Y201209: 118.31,
                              Y201210: 118.31,
                              Y201211: 118.31,
                              Y201212: 120.60,
                              Y201301: 120.60,
                              Y201302: 120.60,
                              Y201303: 120.60,
                              Y201304: 120.60,
                              Y201305: 120.60,
                              Y201306: 120.60,
                              Y201307: 121.01,
                              Y201308: 121.29
                            },
                            {
                              Cls: '포장용플라스틱제품',
                              Y201208: 113.01,
                              Y201209: 113.01,
                              Y201210: 114.28,
                              Y201211: 114.28,
                              Y201212: 114.28,
                              Y201301: 114.28,
                              Y201302: 114.28,
                              Y201303: 114.89,
                              Y201304: 115.90,
                              Y201305: 115.90,
                              Y201306: 115.90,
                              Y201307: 116.53,
                              Y201308: 116.53
                            },
                            {
                              Cls: '조립용플라스틱제품',
                              Y201208: 99.57,
                              Y201209: 98.26,
                              Y201210: 97.93,
                              Y201211: 97.93,
                              Y201212: 97.44,
                              Y201301: 95.78,
                              Y201302: 95.78,
                              Y201303: 95.52,
                              Y201304: 95.34,
                              Y201305: 95.05,
                              Y201306: 94.20,
                              Y201307: 94.34,
                              Y201308: 94.00
                            },
                            {
                              Cls: '기타플라스틱제품',
                              Y201208: 111.93,
                              Y201209: 111.93,
                              Y201210: 111.93,
                              Y201211: 112.46,
                              Y201212: 112.46,
                              Y201301: 112.46,
                              Y201302: 113.33,
                              Y201303: 113.99,
                              Y201304: 113.99,
                              Y201305: 113.99,
                              Y201306: 113.55,
                              Y201307: 113.55,
                              Y201308: 114.29
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '고무제품',
                      Y201208: 115.34,
                      Y201209: 115.25,
                      Y201210: 115.14,
                      Y201211: 115.02,
                      Y201212: 115.02,
                      Y201301: 114.92,
                      Y201302: 114.90,
                      Y201303: 114.92,
                      Y201304: 114.78,
                      Y201305: 114.71,
                      Y201306: 114.65,
                      Y201307: 114.65,
                      Y201308: 114.65,
                      Items: [
                        {
                          Cls: '타이어및튜브',
                          Y201208: 114.65,
                          Y201209: 114.50,
                          Y201210: 114.55,
                          Y201211: 114.54,
                          Y201212: 114.45,
                          Y201301: 114.45,
                          Y201302: 114.45,
                          Y201303: 114.47,
                          Y201304: 114.47,
                          Y201305: 114.47,
                          Y201306: 114.39,
                          Y201307: 114.34,
                          Y201308: 114.34,
                          Items: [
                            {
                              Cls: '타이어및튜브',
                              Y201208: 114.65,
                              Y201209: 114.50,
                              Y201210: 114.55,
                              Y201211: 114.54,
                              Y201212: 114.45,
                              Y201301: 114.45,
                              Y201302: 114.45,
                              Y201303: 114.47,
                              Y201304: 114.47,
                              Y201305: 114.47,
                              Y201306: 114.39,
                              Y201307: 114.34,
                              Y201308: 114.34
                            }
                          ]
                        },
                        {
                          Cls: '기타고무제품',
                          Y201208: 115.70,
                          Y201209: 115.64,
                          Y201210: 115.46,
                          Y201211: 115.27,
                          Y201212: 115.32,
                          Y201301: 115.15,
                          Y201302: 115.12,
                          Y201303: 115.14,
                          Y201304: 114.92,
                          Y201305: 114.79,
                          Y201306: 114.74,
                          Y201307: 114.79,
                          Y201308: 114.79,
                          Items: [
                            {
                              Cls: '산업용고무제품',
                              Y201208: 114.01,
                              Y201209: 113.94,
                              Y201210: 113.70,
                              Y201211: 113.45,
                              Y201212: 113.53,
                              Y201301: 113.31,
                              Y201302: 113.28,
                              Y201303: 113.30,
                              Y201304: 113.01,
                              Y201305: 112.86,
                              Y201306: 112.79,
                              Y201307: 112.86,
                              Y201308: 112.86
                            },
                            {
                              Cls: '기타고무제품',
                              Y201208: 122.42,
                              Y201209: 122.42,
                              Y201210: 122.42,
                              Y201211: 122.42,
                              Y201212: 122.42,
                              Y201301: 122.42,
                              Y201302: 122.42,
                              Y201303: 122.42,
                              Y201304: 122.42,
                              Y201305: 122.42,
                              Y201306: 122.42,
                              Y201307: 122.42,
                              Y201308: 122.42
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '비금속광물제품',
                  Y201208: 103.29,
                  Y201209: 103.30,
                  Y201210: 103.38,
                  Y201211: 102.81,
                  Y201212: 101.79,
                  Y201301: 100.28,
                  Y201302: 100.75,
                  Y201303: 100.67,
                  Y201304: 99.73,
                  Y201305: 99.37,
                  Y201306: 99.58,
                  Y201307: 99.09,
                  Y201308: 99.17,
                  Items: [
                    {
                      Cls: '유리제품',
                      Y201208: 86.47,
                      Y201209: 86.55,
                      Y201210: 86.81,
                      Y201211: 84.92,
                      Y201212: 81.98,
                      Y201301: 78.11,
                      Y201302: 77.15,
                      Y201303: 76.95,
                      Y201304: 76.50,
                      Y201305: 75.48,
                      Y201306: 76.06,
                      Y201307: 75.45,
                      Y201308: 75.59,
                      Items: [
                        {
                          Cls: '유리제품',
                          Y201208: 86.47,
                          Y201209: 86.55,
                          Y201210: 86.81,
                          Y201211: 84.92,
                          Y201212: 81.98,
                          Y201301: 78.11,
                          Y201302: 77.15,
                          Y201303: 76.95,
                          Y201304: 76.50,
                          Y201305: 75.48,
                          Y201306: 76.06,
                          Y201307: 75.45,
                          Y201308: 75.59,
                          Items: [
                            {
                              Cls: '판유리및1차유리',
                              Y201208: 113.95,
                              Y201209: 113.95,
                              Y201210: 113.95,
                              Y201211: 113.95,
                              Y201212: 113.95,
                              Y201301: 113.95,
                              Y201302: 113.95,
                              Y201303: 113.95,
                              Y201304: 113.95,
                              Y201305: 113.95,
                              Y201306: 113.95,
                              Y201307: 113.95,
                              Y201308: 113.95
                            },
                            {
                              Cls: '전자기기용유리제품',
                              Y201208: 75.29,
                              Y201209: 75.29,
                              Y201210: 75.29,
                              Y201211: 72.32,
                              Y201212: 67.71,
                              Y201301: 62.12,
                              Y201302: 60.63,
                              Y201303: 60.38,
                              Y201304: 59.75,
                              Y201305: 58.22,
                              Y201306: 59.12,
                              Y201307: 58.26,
                              Y201308: 58.54
                            },
                            {
                              Cls: '산업용(전자기기용제외)유리제품',
                              Y201208: 101.49,
                              Y201209: 101.49,
                              Y201210: 102.49,
                              Y201211: 102.49,
                              Y201212: 102.49,
                              Y201301: 102.48,
                              Y201302: 102.64,
                              Y201303: 102.52,
                              Y201304: 102.29,
                              Y201305: 102.32,
                              Y201306: 102.18,
                              Y201307: 102.07,
                              Y201308: 101.86
                            },
                            {
                              Cls: '기타유리제품',
                              Y201208: 103.74,
                              Y201209: 105.29,
                              Y201210: 105.29,
                              Y201211: 105.97,
                              Y201212: 107.05,
                              Y201301: 107.05,
                              Y201302: 107.71,
                              Y201303: 107.83,
                              Y201304: 108.50,
                              Y201305: 109.15,
                              Y201306: 109.15,
                              Y201307: 109.15,
                              Y201308: 109.15
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '도자기및점토제품',
                      Y201208: 106.98,
                      Y201209: 106.98,
                      Y201210: 106.98,
                      Y201211: 106.98,
                      Y201212: 107.23,
                      Y201301: 107.23,
                      Y201302: 107.23,
                      Y201303: 107.23,
                      Y201304: 107.23,
                      Y201305: 107.23,
                      Y201306: 107.23,
                      Y201307: 107.23,
                      Y201308: 107.40,
                      Items: [
                        {
                          Cls: '도자기및점토제품',
                          Y201208: 106.98,
                          Y201209: 106.98,
                          Y201210: 106.98,
                          Y201211: 106.98,
                          Y201212: 107.23,
                          Y201301: 107.23,
                          Y201302: 107.23,
                          Y201303: 107.23,
                          Y201304: 107.23,
                          Y201305: 107.23,
                          Y201306: 107.23,
                          Y201307: 107.23,
                          Y201308: 107.40,
                          Items: [
                            {
                              Cls: '가정용도자기',
                              Y201208: 106.82,
                              Y201209: 106.82,
                              Y201210: 106.82,
                              Y201211: 106.82,
                              Y201212: 106.82,
                              Y201301: 106.82,
                              Y201302: 106.82,
                              Y201303: 106.82,
                              Y201304: 106.82,
                              Y201305: 106.82,
                              Y201306: 106.82,
                              Y201307: 106.82,
                              Y201308: 106.82
                            },
                            {
                              Cls: '산업용도자기',
                              Y201208: 103.16,
                              Y201209: 103.16,
                              Y201210: 103.16,
                              Y201211: 103.16,
                              Y201212: 105.22,
                              Y201301: 105.22,
                              Y201302: 105.22,
                              Y201303: 105.22,
                              Y201304: 105.22,
                              Y201305: 105.22,
                              Y201306: 105.22,
                              Y201307: 105.22,
                              Y201308: 105.22
                            },
                            {
                              Cls: '내화요업제품',
                              Y201208: 108.91,
                              Y201209: 108.91,
                              Y201210: 108.91,
                              Y201211: 108.91,
                              Y201212: 108.91,
                              Y201301: 108.91,
                              Y201302: 108.91,
                              Y201303: 108.91,
                              Y201304: 108.91,
                              Y201305: 108.91,
                              Y201306: 108.91,
                              Y201307: 108.91,
                              Y201308: 108.91
                            },
                            {
                              Cls: '건설용점토제품',
                              Y201208: 102.32,
                              Y201209: 102.32,
                              Y201210: 102.32,
                              Y201211: 102.32,
                              Y201212: 102.32,
                              Y201301: 102.32,
                              Y201302: 102.32,
                              Y201303: 102.32,
                              Y201304: 102.32,
                              Y201305: 102.32,
                              Y201306: 102.32,
                              Y201307: 102.32,
                              Y201308: 102.92
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '시멘트및콘크리트제품',
                      Y201208: 113.15,
                      Y201209: 113.15,
                      Y201210: 113.15,
                      Y201211: 113.15,
                      Y201212: 113.15,
                      Y201301: 113.15,
                      Y201302: 115.08,
                      Y201303: 115.08,
                      Y201304: 113.15,
                      Y201305: 113.22,
                      Y201306: 113.26,
                      Y201307: 113.26,
                      Y201308: 113.30,
                      Items: [
                        {
                          Cls: '시멘트',
                          Y201208: 116.57,
                          Y201209: 116.57,
                          Y201210: 116.57,
                          Y201211: 116.57,
                          Y201212: 116.57,
                          Y201301: 116.57,
                          Y201302: 126.86,
                          Y201303: 126.86,
                          Y201304: 116.57,
                          Y201305: 116.57,
                          Y201306: 116.57,
                          Y201307: 116.57,
                          Y201308: 116.57,
                          Items: [
                            {
                              Cls: '시멘트',
                              Y201208: 116.57,
                              Y201209: 116.57,
                              Y201210: 116.57,
                              Y201211: 116.57,
                              Y201212: 116.57,
                              Y201301: 116.57,
                              Y201302: 126.86,
                              Y201303: 126.86,
                              Y201304: 116.57,
                              Y201305: 116.57,
                              Y201306: 116.57,
                              Y201307: 116.57,
                              Y201308: 116.57
                            }
                          ]
                        },
                        {
                          Cls: '콘크리트제품',
                          Y201208: 112.22,
                          Y201209: 112.22,
                          Y201210: 112.22,
                          Y201211: 112.22,
                          Y201212: 112.22,
                          Y201301: 112.22,
                          Y201302: 112.22,
                          Y201303: 112.22,
                          Y201304: 112.22,
                          Y201305: 112.31,
                          Y201306: 112.37,
                          Y201307: 112.37,
                          Y201308: 112.40,
                          Items: [
                            {
                              Cls: '레미콘',
                              Y201208: 112.40,
                              Y201209: 112.40,
                              Y201210: 112.40,
                              Y201211: 112.40,
                              Y201212: 112.40,
                              Y201301: 112.40,
                              Y201302: 112.40,
                              Y201303: 112.40,
                              Y201304: 112.40,
                              Y201305: 112.52,
                              Y201306: 112.60,
                              Y201307: 112.60,
                              Y201308: 112.60
                            },
                            {
                              Cls: '콘크리트제품',
                              Y201208: 112.13,
                              Y201209: 112.13,
                              Y201210: 112.13,
                              Y201211: 112.13,
                              Y201212: 112.13,
                              Y201301: 112.13,
                              Y201302: 112.13,
                              Y201303: 112.13,
                              Y201304: 112.13,
                              Y201305: 112.13,
                              Y201306: 112.13,
                              Y201307: 112.13,
                              Y201308: 112.26
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '기타비금속광물제품',
                      Y201208: 107.44,
                      Y201209: 107.27,
                      Y201210: 107.21,
                      Y201211: 107.69,
                      Y201212: 107.55,
                      Y201301: 107.55,
                      Y201302: 108.01,
                      Y201303: 108.01,
                      Y201304: 108.01,
                      Y201305: 108.01,
                      Y201306: 107.87,
                      Y201307: 106.35,
                      Y201308: 106.35,
                      Items: [
                        {
                          Cls: '기타비금속광물제품',
                          Y201208: 107.44,
                          Y201209: 107.27,
                          Y201210: 107.21,
                          Y201211: 107.69,
                          Y201212: 107.55,
                          Y201301: 107.55,
                          Y201302: 108.01,
                          Y201303: 108.01,
                          Y201304: 108.01,
                          Y201305: 108.01,
                          Y201306: 107.87,
                          Y201307: 106.35,
                          Y201308: 106.35,
                          Items: [
                            {
                              Cls: '석회및석고제품',
                              Y201208: 109.74,
                              Y201209: 108.78,
                              Y201210: 108.41,
                              Y201211: 108.41,
                              Y201212: 108.41,
                              Y201301: 108.41,
                              Y201302: 108.41,
                              Y201303: 108.41,
                              Y201304: 108.41,
                              Y201305: 108.41,
                              Y201306: 108.41,
                              Y201307: 108.41,
                              Y201308: 108.41
                            },
                            {
                              Cls: '석제품',
                              Y201208: 95.52,
                              Y201209: 95.52,
                              Y201210: 95.52,
                              Y201211: 97.59,
                              Y201212: 97.59,
                              Y201301: 97.59,
                              Y201302: 100.55,
                              Y201303: 100.55,
                              Y201304: 100.55,
                              Y201305: 100.55,
                              Y201306: 99.61,
                              Y201307: 99.61,
                              Y201308: 99.61
                            },
                            {
                              Cls: '연마재',
                              Y201208: 115.13,
                              Y201209: 115.13,
                              Y201210: 115.13,
                              Y201211: 115.13,
                              Y201212: 115.13,
                              Y201301: 115.13,
                              Y201302: 115.13,
                              Y201303: 115.13,
                              Y201304: 115.13,
                              Y201305: 115.13,
                              Y201306: 115.13,
                              Y201307: 115.13,
                              Y201308: 115.13
                            },
                            {
                              Cls: '아스팔트제품',
                              Y201208: 113.63,
                              Y201209: 113.63,
                              Y201210: 113.63,
                              Y201211: 113.63,
                              Y201212: 113.63,
                              Y201301: 113.63,
                              Y201302: 113.63,
                              Y201303: 113.63,
                              Y201304: 113.63,
                              Y201305: 113.63,
                              Y201306: 113.63,
                              Y201307: 110.14,
                              Y201308: 110.14
                            },
                            {
                              Cls: '석면및암면',
                              Y201208: 109.67,
                              Y201209: 109.67,
                              Y201210: 109.67,
                              Y201211: 109.67,
                              Y201212: 109.67,
                              Y201301: 109.67,
                              Y201302: 109.67,
                              Y201303: 109.67,
                              Y201304: 109.67,
                              Y201305: 109.67,
                              Y201306: 109.67,
                              Y201307: 109.67,
                              Y201308: 109.67
                            },
                            {
                              Cls: '기타비금속광물제품',
                              Y201208: 112.27,
                              Y201209: 112.27,
                              Y201210: 112.27,
                              Y201211: 112.27,
                              Y201212: 111.27,
                              Y201301: 111.27,
                              Y201302: 111.27,
                              Y201303: 111.27,
                              Y201304: 111.27,
                              Y201305: 111.27,
                              Y201306: 111.27,
                              Y201307: 109.71,
                              Y201308: 109.71
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '제1차금속제품',
                  Y201208: 104.68,
                  Y201209: 104.36,
                  Y201210: 100.73,
                  Y201211: 99.57,
                  Y201212: 98.40,
                  Y201301: 98.80,
                  Y201302: 99.60,
                  Y201303: 97.74,
                  Y201304: 97.75,
                  Y201305: 97.00,
                  Y201306: 96.65,
                  Y201307: 94.85,
                  Y201308: 94.72,
                  Items: [
                    {
                      Cls: '선철및조강',
                      Y201208: 107.12,
                      Y201209: 106.03,
                      Y201210: 99.51,
                      Y201211: 97.56,
                      Y201212: 95.49,
                      Y201301: 96.23,
                      Y201302: 97.77,
                      Y201303: 96.23,
                      Y201304: 97.67,
                      Y201305: 97.15,
                      Y201306: 97.08,
                      Y201307: 94.10,
                      Y201308: 93.86,
                      Items: [
                        {
                          Cls: '선철및조강',
                          Y201208: 107.12,
                          Y201209: 106.03,
                          Y201210: 99.51,
                          Y201211: 97.56,
                          Y201212: 95.49,
                          Y201301: 96.23,
                          Y201302: 97.77,
                          Y201303: 96.23,
                          Y201304: 97.67,
                          Y201305: 97.15,
                          Y201306: 97.08,
                          Y201307: 94.10,
                          Y201308: 93.86,
                          Items: [
                            {
                              Cls: '선철',
                              Y201208: 104.41,
                              Y201209: 104.46,
                              Y201210: 96.35,
                              Y201211: 96.00,
                              Y201212: 96.04,
                              Y201301: 96.38,
                              Y201302: 96.45,
                              Y201303: 96.52,
                              Y201304: 96.33,
                              Y201305: 96.16,
                              Y201306: 96.02,
                              Y201307: 91.47,
                              Y201308: 91.60
                            },
                            {
                              Cls: '합금철',
                              Y201208: 87.59,
                              Y201209: 85.56,
                              Y201210: 85.56,
                              Y201211: 82.51,
                              Y201212: 82.51,
                              Y201301: 82.51,
                              Y201302: 82.51,
                              Y201303: 84.53,
                              Y201304: 84.53,
                              Y201305: 84.53,
                              Y201306: 83.48,
                              Y201307: 83.48,
                              Y201308: 82.39
                            },
                            {
                              Cls: '조강',
                              Y201208: 108.62,
                              Y201209: 107.03,
                              Y201210: 101.10,
                              Y201211: 98.46,
                              Y201212: 95.39,
                              Y201301: 96.34,
                              Y201302: 98.67,
                              Y201303: 96.24,
                              Y201304: 98.51,
                              Y201305: 97.81,
                              Y201306: 97.80,
                              Y201307: 95.53,
                              Y201308: 95.12
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '철강1차제품',
                      Y201208: 104.60,
                      Y201209: 103.57,
                      Y201210: 100.36,
                      Y201211: 99.80,
                      Y201212: 98.86,
                      Y201301: 99.23,
                      Y201302: 99.53,
                      Y201303: 97.00,
                      Y201304: 97.01,
                      Y201305: 96.10,
                      Y201306: 95.79,
                      Y201307: 94.45,
                      Y201308: 94.13,
                      Items: [
                        {
                          Cls: '열간압연강재',
                          Y201208: 105.89,
                          Y201209: 104.49,
                          Y201210: 100.06,
                          Y201211: 98.73,
                          Y201212: 97.89,
                          Y201301: 98.44,
                          Y201302: 99.34,
                          Y201303: 95.75,
                          Y201304: 95.79,
                          Y201305: 95.07,
                          Y201306: 94.68,
                          Y201307: 92.96,
                          Y201308: 92.63,
                          Items: [
                            {
                              Cls: '철근및봉강',
                              Y201208: 109.44,
                              Y201209: 108.73,
                              Y201210: 105.29,
                              Y201211: 105.01,
                              Y201212: 102.74,
                              Y201301: 107.16,
                              Y201302: 108.31,
                              Y201303: 103.56,
                              Y201304: 102.99,
                              Y201305: 100.87,
                              Y201306: 100.87,
                              Y201307: 99.73,
                              Y201308: 100.42
                            },
                            {
                              Cls: '형강',
                              Y201208: 109.78,
                              Y201209: 108.25,
                              Y201210: 108.25,
                              Y201211: 107.84,
                              Y201212: 107.44,
                              Y201301: 107.84,
                              Y201302: 108.24,
                              Y201303: 106.85,
                              Y201304: 105.53,
                              Y201305: 102.97,
                              Y201306: 103.34,
                              Y201307: 103.88,
                              Y201308: 103.88
                            },
                            {
                              Cls: '선재및궤조',
                              Y201208: 114.04,
                              Y201209: 109.96,
                              Y201210: 97.86,
                              Y201211: 97.86,
                              Y201212: 96.69,
                              Y201301: 99.57,
                              Y201302: 101.99,
                              Y201303: 93.17,
                              Y201304: 93.82,
                              Y201305: 99.49,
                              Y201306: 92.86,
                              Y201307: 96.83,
                              Y201308: 94.86
                            },
                            {
                              Cls: '열연후판및강판',
                              Y201208: 100.42,
                              Y201209: 98.63,
                              Y201210: 92.44,
                              Y201211: 89.78,
                              Y201212: 89.35,
                              Y201301: 88.80,
                              Y201302: 89.98,
                              Y201303: 85.18,
                              Y201304: 86.38,
                              Y201305: 85.58,
                              Y201306: 85.43,
                              Y201307: 82.14,
                              Y201308: 81.57
                            },
                            {
                              Cls: '강선',
                              Y201208: 111.98,
                              Y201209: 111.61,
                              Y201210: 110.10,
                              Y201211: 109.77,
                              Y201212: 109.59,
                              Y201301: 109.59,
                              Y201302: 109.74,
                              Y201303: 110.48,
                              Y201304: 109.91,
                              Y201305: 109.79,
                              Y201306: 109.71,
                              Y201307: 109.49,
                              Y201308: 109.44
                            },
                            {
                              Cls: '철강관',
                              Y201208: 111.15,
                              Y201209: 110.73,
                              Y201210: 110.60,
                              Y201211: 110.60,
                              Y201212: 110.05,
                              Y201301: 110.08,
                              Y201302: 109.90,
                              Y201303: 109.90,
                              Y201304: 107.31,
                              Y201305: 106.62,
                              Y201306: 106.62,
                              Y201307: 105.86,
                              Y201308: 105.61
                            }
                          ]
                        },
                        {
                          Cls: '냉간압연강재',
                          Y201208: 109.79,
                          Y201209: 109.35,
                          Y201210: 108.95,
                          Y201211: 108.95,
                          Y201212: 108.87,
                          Y201301: 108.79,
                          Y201302: 108.57,
                          Y201303: 106.89,
                          Y201304: 106.77,
                          Y201305: 106.02,
                          Y201306: 106.05,
                          Y201307: 105.02,
                          Y201308: 104.21,
                          Items: [
                            {
                              Cls: '냉간압연강재',
                              Y201208: 109.79,
                              Y201209: 109.35,
                              Y201210: 108.95,
                              Y201211: 108.95,
                              Y201212: 108.87,
                              Y201301: 108.79,
                              Y201302: 108.57,
                              Y201303: 106.89,
                              Y201304: 106.77,
                              Y201305: 106.02,
                              Y201306: 106.05,
                              Y201307: 105.02,
                              Y201308: 104.21
                            }
                          ]
                        },
                        {
                          Cls: '기타철강1차제품',
                          Y201208: 96.75,
                          Y201209: 96.70,
                          Y201210: 96.32,
                          Y201211: 98.35,
                          Y201212: 96.43,
                          Y201301: 96.43,
                          Y201302: 95.08,
                          Y201303: 95.58,
                          Y201304: 95.58,
                          Y201305: 93.94,
                          Y201306: 93.65,
                          Y201307: 93.40,
                          Y201308: 93.40,
                          Items: [
                            {
                              Cls: '표면처리강재',
                              Y201208: 101.31,
                              Y201209: 101.19,
                              Y201210: 100.20,
                              Y201211: 100.37,
                              Y201212: 100.17,
                              Y201301: 100.17,
                              Y201302: 100.47,
                              Y201303: 101.58,
                              Y201304: 101.58,
                              Y201305: 99.15,
                              Y201306: 99.12,
                              Y201307: 99.17,
                              Y201308: 99.17
                            },
                            {
                              Cls: '기타철강1차제품',
                              Y201208: 94.92,
                              Y201209: 94.92,
                              Y201210: 94.92,
                              Y201211: 98.15,
                              Y201212: 95.10,
                              Y201301: 95.10,
                              Y201302: 92.38,
                              Y201303: 92.38,
                              Y201304: 92.38,
                              Y201305: 91.37,
                              Y201306: 90.87,
                              Y201307: 90.35,
                              Y201308: 90.35
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '비철금속괴및1차제품',
                      Y201208: 96.56,
                      Y201209: 99.88,
                      Y201210: 99.75,
                      Y201211: 98.08,
                      Y201212: 97.71,
                      Y201301: 97.76,
                      Y201302: 99.07,
                      Y201303: 97.76,
                      Y201304: 94.73,
                      Y201305: 93.61,
                      Y201306: 92.38,
                      Y201307: 91.19,
                      Y201308: 91.97,
                      Items: [
                        {
                          Cls: '비철금속괴',
                          Y201208: 93.11,
                          Y201209: 97.90,
                          Y201210: 97.13,
                          Y201211: 93.69,
                          Y201212: 95.51,
                          Y201301: 95.76,
                          Y201302: 97.73,
                          Y201303: 95.27,
                          Y201304: 91.91,
                          Y201305: 91.10,
                          Y201306: 89.40,
                          Y201307: 87.60,
                          Y201308: 89.20,
                          Items: [
                            {
                              Cls: '동제련,정련및합금제품',
                              Y201208: 98.14,
                              Y201209: 104.87,
                              Y201210: 103.22,
                              Y201211: 96.79,
                              Y201212: 99.12,
                              Y201301: 99.69,
                              Y201302: 103.40,
                              Y201303: 98.18,
                              Y201304: 94.01,
                              Y201305: 95.98,
                              Y201306: 92.53,
                              Y201307: 90.44,
                              Y201308: 93.33
                            },
                            {
                              Cls: '알루미늄제련,정련및합금제품',
                              Y201208: 92.22,
                              Y201209: 98.93,
                              Y201210: 95.19,
                              Y201211: 93.86,
                              Y201212: 97.81,
                              Y201301: 95.93,
                              Y201302: 97.14,
                              Y201303: 93.62,
                              Y201304: 92.22,
                              Y201305: 90.71,
                              Y201306: 90.54,
                              Y201307: 88.65,
                              Y201308: 89.61
                            },
                            {
                              Cls: '연및아연제련,정련및합금제품',
                              Y201208: 83.77,
                              Y201209: 81.82,
                              Y201210: 89.73,
                              Y201211: 85.22,
                              Y201212: 83.70,
                              Y201301: 87.81,
                              Y201302: 87.60,
                              Y201303: 91.44,
                              Y201304: 85.37,
                              Y201305: 83.64,
                              Y201306: 82.42,
                              Y201307: 85.00,
                              Y201308: 84.66
                            },
                            {
                              Cls: '금은괴',
                              Y201208: 130.20,
                              Y201209: 138.25,
                              Y201210: 132.39,
                              Y201211: 132.37,
                              Y201212: 128.54,
                              Y201301: 125.83,
                              Y201302: 124.93,
                              Y201303: 124.16,
                              Y201304: 118.14,
                              Y201305: 111.23,
                              Y201306: 107.86,
                              Y201307: 107.86,
                              Y201308: 107.86
                            },
                            {
                              Cls: '기타비철금속제련,정련및합금제품',
                              Y201208: 83.45,
                              Y201209: 79.28,
                              Y201210: 85.25,
                              Y201211: 85.37,
                              Y201212: 80.70,
                              Y201301: 82.95,
                              Y201302: 84.90,
                              Y201303: 87.70,
                              Y201304: 83.94,
                              Y201305: 77.68,
                              Y201306: 75.92,
                              Y201307: 69.10,
                              Y201308: 71.36
                            }
                          ]
                        },
                        {
                          Cls: '비철금속1차제품',
                          Y201208: 99.40,
                          Y201209: 101.31,
                          Y201210: 101.78,
                          Y201211: 101.77,
                          Y201212: 99.35,
                          Y201301: 99.21,
                          Y201302: 99.93,
                          Y201303: 99.67,
                          Y201304: 96.94,
                          Y201305: 95.54,
                          Y201306: 94.75,
                          Y201307: 94.13,
                          Y201308: 94.16,
                          Items: [
                            {
                              Cls: '동1차제품',
                              Y201208: 101.58,
                              Y201209: 103.75,
                              Y201210: 104.84,
                              Y201211: 103.73,
                              Y201212: 100.85,
                              Y201301: 101.64,
                              Y201302: 102.22,
                              Y201303: 101.82,
                              Y201304: 98.93,
                              Y201305: 97.13,
                              Y201306: 96.95,
                              Y201307: 96.03,
                              Y201308: 95.83
                            },
                            {
                              Cls: '알루미늄1차제품',
                              Y201208: 95.25,
                              Y201209: 96.46,
                              Y201210: 96.10,
                              Y201211: 97.84,
                              Y201212: 96.42,
                              Y201301: 94.74,
                              Y201302: 96.57,
                              Y201303: 96.61,
                              Y201304: 94.13,
                              Y201305: 94.02,
                              Y201306: 93.48,
                              Y201307: 93.43,
                              Y201308: 93.38
                            },
                            {
                              Cls: '기타비철금속1차제품',
                              Y201208: 94.77,
                              Y201209: 97.03,
                              Y201210: 97.32,
                              Y201211: 97.17,
                              Y201212: 94.48,
                              Y201301: 95.24,
                              Y201302: 94.51,
                              Y201303: 94.05,
                              Y201304: 91.37,
                              Y201305: 88.87,
                              Y201306: 86.89,
                              Y201307: 85.96,
                              Y201308: 86.42
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '주단강품',
                      Y201208: 106.94,
                      Y201209: 106.84,
                      Y201210: 106.54,
                      Y201211: 106.43,
                      Y201212: 106.35,
                      Y201301: 106.04,
                      Y201302: 105.45,
                      Y201303: 105.92,
                      Y201304: 105.00,
                      Y201305: 104.95,
                      Y201306: 104.79,
                      Y201307: 104.49,
                      Y201308: 104.52,
                      Items: [
                        {
                          Cls: '주단강품',
                          Y201208: 106.94,
                          Y201209: 106.84,
                          Y201210: 106.54,
                          Y201211: 106.43,
                          Y201212: 106.35,
                          Y201301: 106.04,
                          Y201302: 105.45,
                          Y201303: 105.92,
                          Y201304: 105.00,
                          Y201305: 104.95,
                          Y201306: 104.79,
                          Y201307: 104.49,
                          Y201308: 104.52,
                          Items: [
                            {
                              Cls: '금속주물',
                              Y201208: 102.76,
                              Y201209: 102.60,
                              Y201210: 102.95,
                              Y201211: 102.78,
                              Y201212: 102.92,
                              Y201301: 102.57,
                              Y201302: 102.20,
                              Y201303: 102.22,
                              Y201304: 102.10,
                              Y201305: 101.99,
                              Y201306: 101.95,
                              Y201307: 101.07,
                              Y201308: 101.13
                            },
                            {
                              Cls: '금속단조및야금제품',
                              Y201208: 112.70,
                              Y201209: 112.70,
                              Y201210: 111.40,
                              Y201211: 111.40,
                              Y201212: 110.98,
                              Y201301: 110.72,
                              Y201302: 109.85,
                              Y201303: 110.89,
                              Y201304: 108.96,
                              Y201305: 108.96,
                              Y201306: 108.66,
                              Y201307: 109.09,
                              Y201308: 109.09
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '금속제품',
                  Y201208: 107.47,
                  Y201209: 107.49,
                  Y201210: 107.83,
                  Y201211: 107.49,
                  Y201212: 107.42,
                  Y201301: 107.38,
                  Y201302: 107.11,
                  Y201303: 107.42,
                  Y201304: 107.68,
                  Y201305: 107.73,
                  Y201306: 107.53,
                  Y201307: 107.46,
                  Y201308: 107.41,
                  Items: [
                    {
                      Cls: '건설용금속제품',
                      Y201208: 107.68,
                      Y201209: 107.57,
                      Y201210: 107.57,
                      Y201211: 106.55,
                      Y201212: 106.55,
                      Y201301: 106.55,
                      Y201302: 106.81,
                      Y201303: 107.52,
                      Y201304: 107.38,
                      Y201305: 107.72,
                      Y201306: 107.48,
                      Y201307: 107.10,
                      Y201308: 106.84,
                      Items: [
                        {
                          Cls: '건설용금속제품',
                          Y201208: 107.68,
                          Y201209: 107.57,
                          Y201210: 107.57,
                          Y201211: 106.55,
                          Y201212: 106.55,
                          Y201301: 106.55,
                          Y201302: 106.81,
                          Y201303: 107.52,
                          Y201304: 107.38,
                          Y201305: 107.72,
                          Y201306: 107.48,
                          Y201307: 107.10,
                          Y201308: 106.84,
                          Items: [
                            {
                              Cls: '건축용금속제품',
                              Y201208: 107.68,
                              Y201209: 107.57,
                              Y201210: 107.57,
                              Y201211: 106.55,
                              Y201212: 106.55,
                              Y201301: 106.55,
                              Y201302: 106.81,
                              Y201303: 107.52,
                              Y201304: 107.38,
                              Y201305: 107.72,
                              Y201306: 107.48,
                              Y201307: 107.10,
                              Y201308: 106.84
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '기타금속제품',
                      Y201208: 107.59,
                      Y201209: 107.67,
                      Y201210: 108.18,
                      Y201211: 108.16,
                      Y201212: 108.06,
                      Y201301: 108.01,
                      Y201302: 107.57,
                      Y201303: 107.77,
                      Y201304: 108.16,
                      Y201305: 108.12,
                      Y201306: 107.92,
                      Y201307: 107.95,
                      Y201308: 107.96,
                      Items: [
                        {
                          Cls: '금속제탱크',
                          Y201208: 114.67,
                          Y201209: 114.67,
                          Y201210: 118.73,
                          Y201211: 118.73,
                          Y201212: 118.73,
                          Y201301: 118.73,
                          Y201302: 118.73,
                          Y201303: 119.70,
                          Y201304: 123.25,
                          Y201305: 123.25,
                          Y201306: 123.25,
                          Y201307: 123.25,
                          Y201308: 123.25,
                          Items: [
                            {
                              Cls: '금속제탱크및압력용기',
                              Y201208: 114.67,
                              Y201209: 114.67,
                              Y201210: 118.73,
                              Y201211: 118.73,
                              Y201212: 118.73,
                              Y201301: 118.73,
                              Y201302: 118.73,
                              Y201303: 119.70,
                              Y201304: 123.25,
                              Y201305: 123.25,
                              Y201306: 123.25,
                              Y201307: 123.25,
                              Y201308: 123.25
                            }
                          ]
                        },
                        {
                          Cls: '금속제부착및부속품',
                          Y201208: 105.20,
                          Y201209: 105.20,
                          Y201210: 105.17,
                          Y201211: 105.07,
                          Y201212: 104.31,
                          Y201301: 104.24,
                          Y201302: 101.47,
                          Y201303: 101.49,
                          Y201304: 101.25,
                          Y201305: 101.17,
                          Y201306: 101.18,
                          Y201307: 101.35,
                          Y201308: 101.37,
                          Items: [
                            {
                              Cls: '금속압형제품',
                              Y201208: 105.89,
                              Y201209: 105.89,
                              Y201210: 105.89,
                              Y201211: 105.89,
                              Y201212: 104.59,
                              Y201301: 104.47,
                              Y201302: 100.18,
                              Y201303: 100.17,
                              Y201304: 99.88,
                              Y201305: 99.71,
                              Y201306: 99.72,
                              Y201307: 99.96,
                              Y201308: 99.96
                            },
                            {
                              Cls: '부착용금속제품',
                              Y201208: 97.82,
                              Y201209: 97.83,
                              Y201210: 97.76,
                              Y201211: 97.53,
                              Y201212: 97.51,
                              Y201301: 97.51,
                              Y201302: 97.52,
                              Y201303: 97.59,
                              Y201304: 97.44,
                              Y201305: 97.52,
                              Y201306: 97.52,
                              Y201307: 97.57,
                              Y201308: 97.62
                            }
                          ]
                        },
                        {
                          Cls: '공구및철선제품',
                          Y201208: 112.41,
                          Y201209: 112.62,
                          Y201210: 112.58,
                          Y201211: 112.58,
                          Y201212: 112.76,
                          Y201301: 112.55,
                          Y201302: 112.58,
                          Y201303: 113.03,
                          Y201304: 113.55,
                          Y201305: 113.59,
                          Y201306: 112.99,
                          Y201307: 112.99,
                          Y201308: 112.99,
                          Items: [
                            {
                              Cls: '공구류',
                              Y201208: 108.78,
                              Y201209: 108.78,
                              Y201210: 108.78,
                              Y201211: 108.78,
                              Y201212: 108.78,
                              Y201301: 108.78,
                              Y201302: 108.78,
                              Y201303: 114.09,
                              Y201304: 119.66,
                              Y201305: 119.66,
                              Y201306: 119.66,
                              Y201307: 119.66,
                              Y201308: 119.66
                            },
                            {
                              Cls: '나사및철선제품',
                              Y201208: 112.88,
                              Y201209: 113.09,
                              Y201210: 113.06,
                              Y201211: 113.06,
                              Y201212: 113.25,
                              Y201301: 113.01,
                              Y201302: 113.05,
                              Y201303: 113.05,
                              Y201304: 113.08,
                              Y201305: 113.14,
                              Y201306: 112.46,
                              Y201307: 112.46,
                              Y201308: 112.46
                            }
                          ]
                        },
                        {
                          Cls: '기타금속제품',
                          Y201208: 102.68,
                          Y201209: 102.76,
                          Y201210: 102.76,
                          Y201211: 102.76,
                          Y201212: 102.70,
                          Y201301: 102.72,
                          Y201302: 102.69,
                          Y201303: 102.72,
                          Y201304: 102.72,
                          Y201305: 102.68,
                          Y201306: 102.56,
                          Y201307: 102.57,
                          Y201308: 102.57,
                          Items: [
                            {
                              Cls: '금속포장용기',
                              Y201208: 111.19,
                              Y201209: 111.46,
                              Y201210: 111.46,
                              Y201211: 111.46,
                              Y201212: 111.27,
                              Y201301: 111.27,
                              Y201302: 111.05,
                              Y201303: 111.25,
                              Y201304: 111.13,
                              Y201305: 110.94,
                              Y201306: 110.94,
                              Y201307: 111.00,
                              Y201308: 111.00
                            },
                            {
                              Cls: '가정용금속제품',
                              Y201208: 100.20,
                              Y201209: 100.20,
                              Y201210: 100.20,
                              Y201211: 100.20,
                              Y201212: 100.20,
                              Y201301: 100.20,
                              Y201302: 100.20,
                              Y201303: 100.20,
                              Y201304: 100.53,
                              Y201305: 100.53,
                              Y201306: 100.53,
                              Y201307: 100.53,
                              Y201308: 100.53
                            },
                            {
                              Cls: '기타금속제품',
                              Y201208: 100.41,
                              Y201209: 100.41,
                              Y201210: 100.41,
                              Y201211: 100.41,
                              Y201212: 100.41,
                              Y201301: 100.43,
                              Y201302: 100.43,
                              Y201303: 100.43,
                              Y201304: 100.43,
                              Y201305: 100.40,
                              Y201306: 100.26,
                              Y201307: 100.26,
                              Y201308: 100.26
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '일반기계',
                  Y201208: 106.85,
                  Y201209: 106.87,
                  Y201210: 106.88,
                  Y201211: 106.87,
                  Y201212: 106.87,
                  Y201301: 106.71,
                  Y201302: 106.66,
                  Y201303: 106.70,
                  Y201304: 106.69,
                  Y201305: 107.15,
                  Y201306: 107.15,
                  Y201307: 107.18,
                  Y201308: 107.16,
                  Items: [
                    {
                      Cls: '일반목적용기계및장비',
                      Y201208: 108.21,
                      Y201209: 108.21,
                      Y201210: 108.06,
                      Y201211: 108.04,
                      Y201212: 108.04,
                      Y201301: 107.74,
                      Y201302: 107.66,
                      Y201303: 107.75,
                      Y201304: 107.76,
                      Y201305: 108.89,
                      Y201306: 108.89,
                      Y201307: 108.90,
                      Y201308: 108.88,
                      Items: [
                        {
                          Cls: '내연기관및터빈',
                          Y201208: 106.99,
                          Y201209: 106.99,
                          Y201210: 106.99,
                          Y201211: 106.99,
                          Y201212: 106.99,
                          Y201301: 106.84,
                          Y201302: 106.84,
                          Y201303: 107.79,
                          Y201304: 107.79,
                          Y201305: 107.79,
                          Y201306: 107.79,
                          Y201307: 107.79,
                          Y201308: 107.79,
                          Items: [
                            {
                              Cls: '내연기관및터빈',
                              Y201208: 106.99,
                              Y201209: 106.99,
                              Y201210: 106.99,
                              Y201211: 106.99,
                              Y201212: 106.99,
                              Y201301: 106.84,
                              Y201302: 106.84,
                              Y201303: 107.79,
                              Y201304: 107.79,
                              Y201305: 107.79,
                              Y201306: 107.79,
                              Y201307: 107.79,
                              Y201308: 107.79
                            }
                          ]
                        },
                        {
                          Cls: '일반목적용기계부품',
                          Y201208: 112.13,
                          Y201209: 112.13,
                          Y201210: 112.22,
                          Y201211: 112.22,
                          Y201212: 112.22,
                          Y201301: 112.22,
                          Y201302: 112.15,
                          Y201303: 112.15,
                          Y201304: 112.15,
                          Y201305: 112.15,
                          Y201306: 112.14,
                          Y201307: 112.15,
                          Y201308: 112.20,
                          Items: [
                            {
                              Cls: '밸브',
                              Y201208: 109.35,
                              Y201209: 109.35,
                              Y201210: 109.53,
                              Y201211: 109.53,
                              Y201212: 109.53,
                              Y201301: 109.53,
                              Y201302: 109.53,
                              Y201303: 109.53,
                              Y201304: 109.53,
                              Y201305: 109.52,
                              Y201306: 109.52,
                              Y201307: 109.55,
                              Y201308: 109.62
                            },
                            {
                              Cls: '베어링,기어및동력전달장치',
                              Y201208: 115.30,
                              Y201209: 115.30,
                              Y201210: 115.30,
                              Y201211: 115.30,
                              Y201212: 115.30,
                              Y201301: 115.30,
                              Y201302: 115.13,
                              Y201303: 115.13,
                              Y201304: 115.13,
                              Y201305: 115.13,
                              Y201306: 115.12,
                              Y201307: 115.12,
                              Y201308: 115.12
                            }
                          ]
                        },
                        {
                          Cls: '산업용운반기계',
                          Y201208: 103.40,
                          Y201209: 103.40,
                          Y201210: 103.47,
                          Y201211: 103.47,
                          Y201212: 103.47,
                          Y201301: 103.47,
                          Y201302: 103.58,
                          Y201303: 103.58,
                          Y201304: 103.60,
                          Y201305: 103.60,
                          Y201306: 103.70,
                          Y201307: 103.70,
                          Y201308: 103.70,
                          Items: [
                            {
                              Cls: '산업용운반기계',
                              Y201208: 103.40,
                              Y201209: 103.40,
                              Y201210: 103.47,
                              Y201211: 103.47,
                              Y201212: 103.47,
                              Y201301: 103.47,
                              Y201302: 103.58,
                              Y201303: 103.58,
                              Y201304: 103.60,
                              Y201305: 103.60,
                              Y201306: 103.70,
                              Y201307: 103.70,
                              Y201308: 103.70
                            }
                          ]
                        },
                        {
                          Cls: '공기및액체조절장치',
                          Y201208: 110.75,
                          Y201209: 110.76,
                          Y201210: 110.16,
                          Y201211: 110.14,
                          Y201212: 110.13,
                          Y201301: 110.11,
                          Y201302: 110.00,
                          Y201303: 109.79,
                          Y201304: 109.79,
                          Y201305: 113.60,
                          Y201306: 113.59,
                          Y201307: 113.59,
                          Y201308: 113.53,
                          Items: [
                            {
                              Cls: '공기조절장치 및 냉장냉동장비',
                              Y201208: 107.07,
                              Y201209: 107.08,
                              Y201210: 107.08,
                              Y201211: 107.04,
                              Y201212: 107.01,
                              Y201301: 106.96,
                              Y201302: 106.73,
                              Y201303: 106.34,
                              Y201304: 106.34,
                              Y201305: 106.68,
                              Y201306: 106.66,
                              Y201307: 106.66,
                              Y201308: 106.53
                            },
                            {
                              Cls: '공기및액체여과기',
                              Y201208: 115.17,
                              Y201209: 115.17,
                              Y201210: 113.33,
                              Y201211: 113.33,
                              Y201212: 113.33,
                              Y201301: 113.33,
                              Y201302: 113.33,
                              Y201303: 113.33,
                              Y201304: 113.33,
                              Y201305: 124.56,
                              Y201306: 124.56,
                              Y201307: 124.56,
                              Y201308: 124.56
                            },
                            {
                              Cls: '산업용보일러및증기발생기',
                              Y201208: 117.22,
                              Y201209: 117.22,
                              Y201210: 117.22,
                              Y201211: 117.22,
                              Y201212: 117.22,
                              Y201301: 117.22,
                              Y201302: 117.22,
                              Y201303: 117.22,
                              Y201304: 117.22,
                              Y201305: 117.22,
                              Y201306: 117.22,
                              Y201307: 117.22,
                              Y201308: 117.22
                            }
                          ]
                        },
                        {
                          Cls: '사무용기기',
                          Y201208: 102.12,
                          Y201209: 102.12,
                          Y201210: 102.12,
                          Y201211: 102.12,
                          Y201212: 102.12,
                          Y201301: 102.12,
                          Y201302: 102.12,
                          Y201303: 102.12,
                          Y201304: 102.12,
                          Y201305: 102.12,
                          Y201306: 102.12,
                          Y201307: 102.12,
                          Y201308: 102.12,
                          Items: [
                            {
                              Cls: '사무용기기',
                              Y201208: 102.12,
                              Y201209: 102.12,
                              Y201210: 102.12,
                              Y201211: 102.12,
                              Y201212: 102.12,
                              Y201301: 102.12,
                              Y201302: 102.12,
                              Y201303: 102.12,
                              Y201304: 102.12,
                              Y201305: 102.12,
                              Y201306: 102.12,
                              Y201307: 102.12,
                              Y201308: 102.12
                            }
                          ]
                        },
                        {
                          Cls: '가정용난방및조리기기',
                          Y201208: 99.70,
                          Y201209: 99.74,
                          Y201210: 99.77,
                          Y201211: 99.77,
                          Y201212: 99.77,
                          Y201301: 99.77,
                          Y201302: 99.77,
                          Y201303: 100.31,
                          Y201304: 100.31,
                          Y201305: 100.42,
                          Y201306: 100.16,
                          Y201307: 100.03,
                          Y201308: 99.94,
                          Items: [
                            {
                              Cls: '가정용난방 및 조리기기(비전기식)',
                              Y201208: 99.70,
                              Y201209: 99.74,
                              Y201210: 99.77,
                              Y201211: 99.77,
                              Y201212: 99.77,
                              Y201301: 99.77,
                              Y201302: 99.77,
                              Y201303: 100.31,
                              Y201304: 100.31,
                              Y201305: 100.42,
                              Y201306: 100.16,
                              Y201307: 100.03,
                              Y201308: 99.94
                            }
                          ]
                        },
                        {
                          Cls: '일반목적용기계',
                          Y201208: 109.44,
                          Y201209: 109.38,
                          Y201210: 109.44,
                          Y201211: 109.35,
                          Y201212: 109.38,
                          Y201301: 108.25,
                          Y201302: 108.03,
                          Y201303: 108.02,
                          Y201304: 108.02,
                          Y201305: 108.01,
                          Y201306: 108.01,
                          Y201307: 108.03,
                          Y201308: 108.03,
                          Items: [
                            {
                              Cls: '펌프및압축기',
                              Y201208: 105.03,
                              Y201209: 104.89,
                              Y201210: 104.86,
                              Y201211: 104.66,
                              Y201212: 104.74,
                              Y201301: 103.78,
                              Y201302: 103.27,
                              Y201303: 103.25,
                              Y201304: 103.25,
                              Y201305: 103.24,
                              Y201306: 103.24,
                              Y201307: 103.29,
                              Y201308: 103.29
                            },
                            {
                              Cls: '기타일반목적용기계',
                              Y201208: 112.12,
                              Y201209: 112.12,
                              Y201210: 112.23,
                              Y201211: 112.23,
                              Y201212: 112.23,
                              Y201301: 110.97,
                              Y201302: 110.97,
                              Y201303: 110.97,
                              Y201304: 110.97,
                              Y201305: 110.97,
                              Y201306: 110.97,
                              Y201307: 110.97,
                              Y201308: 110.97
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '특수목적용기계및장비',
                      Y201208: 104.88,
                      Y201209: 104.94,
                      Y201210: 105.18,
                      Y201211: 105.18,
                      Y201212: 105.18,
                      Y201301: 105.19,
                      Y201302: 105.17,
                      Y201303: 105.14,
                      Y201304: 105.12,
                      Y201305: 104.77,
                      Y201306: 104.77,
                      Y201307: 104.83,
                      Y201308: 104.79,
                      Items: [
                        {
                          Cls: '농업및건설기계',
                          Y201208: 107.47,
                          Y201209: 107.47,
                          Y201210: 109.15,
                          Y201211: 109.15,
                          Y201212: 109.15,
                          Y201301: 109.23,
                          Y201302: 109.25,
                          Y201303: 109.06,
                          Y201304: 109.06,
                          Y201305: 109.06,
                          Y201306: 109.06,
                          Y201307: 109.50,
                          Y201308: 109.50,
                          Items: [
                            {
                              Cls: '농업용기계',
                              Y201208: 111.45,
                              Y201209: 111.45,
                              Y201210: 114.35,
                              Y201211: 114.35,
                              Y201212: 114.35,
                              Y201301: 114.58,
                              Y201302: 114.58,
                              Y201303: 114.58,
                              Y201304: 114.58,
                              Y201305: 114.58,
                              Y201306: 114.58,
                              Y201307: 115.55,
                              Y201308: 115.55
                            },
                            {
                              Cls: '건설및광물처리기계',
                              Y201208: 102.43,
                              Y201209: 102.43,
                              Y201210: 102.43,
                              Y201211: 102.43,
                              Y201212: 102.43,
                              Y201301: 102.38,
                              Y201302: 102.42,
                              Y201303: 102.09,
                              Y201304: 102.09,
                              Y201305: 102.09,
                              Y201306: 102.09,
                              Y201307: 102.09,
                              Y201308: 102.09
                            }
                          ]
                        },
                        {
                          Cls: '금속가공용기계',
                          Y201208: 111.27,
                          Y201209: 111.27,
                          Y201210: 111.27,
                          Y201211: 111.27,
                          Y201212: 111.27,
                          Y201301: 111.27,
                          Y201302: 111.27,
                          Y201303: 111.27,
                          Y201304: 111.27,
                          Y201305: 111.27,
                          Y201306: 111.27,
                          Y201307: 111.27,
                          Y201308: 111.27,
                          Items: [
                            {
                              Cls: '금속절삭기계',
                              Y201208: 109.76,
                              Y201209: 109.76,
                              Y201210: 109.76,
                              Y201211: 109.76,
                              Y201212: 109.76,
                              Y201301: 109.76,
                              Y201302: 109.76,
                              Y201303: 109.76,
                              Y201304: 109.76,
                              Y201305: 109.76,
                              Y201306: 109.76,
                              Y201307: 109.76,
                              Y201308: 109.76
                            },
                            {
                              Cls: '금속성형기계',
                              Y201208: 114.71,
                              Y201209: 114.71,
                              Y201210: 114.71,
                              Y201211: 114.71,
                              Y201212: 114.71,
                              Y201301: 114.71,
                              Y201302: 114.71,
                              Y201303: 114.71,
                              Y201304: 114.71,
                              Y201305: 114.71,
                              Y201306: 114.71,
                              Y201307: 114.71,
                              Y201308: 114.71
                            }
                          ]
                        },
                        {
                          Cls: '반도체 및 평판디스플레이제조기계',
                          Y201208: 98.85,
                          Y201209: 98.85,
                          Y201210: 98.85,
                          Y201211: 98.85,
                          Y201212: 98.85,
                          Y201301: 98.85,
                          Y201302: 98.85,
                          Y201303: 98.85,
                          Y201304: 98.85,
                          Y201305: 97.72,
                          Y201306: 97.72,
                          Y201307: 97.72,
                          Y201308: 97.72,
                          Items: [
                            {
                              Cls: '반도체제조용기계',
                              Y201208: 100.70,
                              Y201209: 100.70,
                              Y201210: 100.70,
                              Y201211: 100.70,
                              Y201212: 100.70,
                              Y201301: 100.70,
                              Y201302: 100.70,
                              Y201303: 100.70,
                              Y201304: 100.70,
                              Y201305: 99.11,
                              Y201306: 99.11,
                              Y201307: 99.11,
                              Y201308: 99.11
                            },
                            {
                              Cls: '평판디스플레이 제조용 기계',
                              Y201208: 94.85,
                              Y201209: 94.85,
                              Y201210: 94.85,
                              Y201211: 94.85,
                              Y201212: 94.85,
                              Y201301: 94.85,
                              Y201302: 94.85,
                              Y201303: 94.85,
                              Y201304: 94.85,
                              Y201305: 94.85,
                              Y201306: 94.85,
                              Y201307: 94.85,
                              Y201308: 94.85
                            }
                          ]
                        },
                        {
                          Cls: '기타특수목적용기계',
                          Y201208: 104.28,
                          Y201209: 104.39,
                          Y201210: 104.39,
                          Y201211: 104.39,
                          Y201212: 104.39,
                          Y201301: 104.39,
                          Y201302: 104.33,
                          Y201303: 104.33,
                          Y201304: 104.25,
                          Y201305: 104.25,
                          Y201306: 104.25,
                          Y201307: 104.25,
                          Y201308: 104.15,
                          Items: [
                            {
                              Cls: '산업용로봇',
                              Y201208: 100.68,
                              Y201209: 102.04,
                              Y201210: 102.04,
                              Y201211: 102.04,
                              Y201212: 102.04,
                              Y201301: 102.04,
                              Y201302: 102.04,
                              Y201303: 102.04,
                              Y201304: 102.04,
                              Y201305: 102.04,
                              Y201306: 102.04,
                              Y201307: 102.04,
                              Y201308: 102.04
                            },
                            {
                              Cls: '금형및주형',
                              Y201208: 99.46,
                              Y201209: 99.46,
                              Y201210: 99.46,
                              Y201211: 99.46,
                              Y201212: 99.46,
                              Y201301: 99.46,
                              Y201302: 99.34,
                              Y201303: 99.34,
                              Y201304: 99.21,
                              Y201305: 99.21,
                              Y201306: 99.21,
                              Y201307: 99.21,
                              Y201308: 99.21
                            },
                            {
                              Cls: '제지및인쇄기계',
                              Y201208: 97.82,
                              Y201209: 97.82,
                              Y201210: 97.82,
                              Y201211: 97.82,
                              Y201212: 97.82,
                              Y201301: 97.82,
                              Y201302: 97.82,
                              Y201303: 97.82,
                              Y201304: 97.82,
                              Y201305: 97.82,
                              Y201306: 97.82,
                              Y201307: 97.82,
                              Y201308: 97.82
                            },
                            {
                              Cls: '고무및플라스틱성형기계',
                              Y201208: 106.21,
                              Y201209: 106.21,
                              Y201210: 106.21,
                              Y201211: 106.21,
                              Y201212: 106.21,
                              Y201301: 106.21,
                              Y201302: 106.21,
                              Y201303: 106.21,
                              Y201304: 106.21,
                              Y201305: 106.21,
                              Y201306: 106.21,
                              Y201307: 106.21,
                              Y201308: 104.29
                            },
                            {
                              Cls: '기타특수목적용기계',
                              Y201208: 118.42,
                              Y201209: 118.42,
                              Y201210: 118.42,
                              Y201211: 118.42,
                              Y201212: 118.42,
                              Y201301: 118.42,
                              Y201302: 118.42,
                              Y201303: 118.42,
                              Y201304: 118.42,
                              Y201305: 118.42,
                              Y201306: 118.42,
                              Y201307: 118.42,
                              Y201308: 118.42
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '전기및전자기기',
                  Y201208: 96.35,
                  Y201209: 96.21,
                  Y201210: 95.70,
                  Y201211: 94.70,
                  Y201212: 94.36,
                  Y201301: 93.89,
                  Y201302: 94.38,
                  Y201303: 94.73,
                  Y201304: 94.74,
                  Y201305: 94.43,
                  Y201306: 94.33,
                  Y201307: 94.36,
                  Y201308: 94.20,
                  Items: [
                    {
                      Cls: '전기기계 및 장치',
                      Y201208: 102.81,
                      Y201209: 103.13,
                      Y201210: 103.14,
                      Y201211: 102.73,
                      Y201212: 102.72,
                      Y201301: 102.83,
                      Y201302: 102.96,
                      Y201303: 102.84,
                      Y201304: 102.68,
                      Y201305: 102.19,
                      Y201306: 102.18,
                      Y201307: 102.25,
                      Y201308: 102.16,
                      Items: [
                        {
                          Cls: '발전기,전동기및전기변환장치',
                          Y201208: 110.53,
                          Y201209: 110.44,
                          Y201210: 110.24,
                          Y201211: 110.06,
                          Y201212: 109.96,
                          Y201301: 109.88,
                          Y201302: 110.12,
                          Y201303: 110.29,
                          Y201304: 110.53,
                          Y201305: 110.41,
                          Y201306: 110.84,
                          Y201307: 111.03,
                          Y201308: 110.92,
                          Items: [
                            {
                              Cls: '발전기및전동기',
                              Y201208: 113.72,
                              Y201209: 113.59,
                              Y201210: 113.30,
                              Y201211: 112.98,
                              Y201212: 112.80,
                              Y201301: 112.82,
                              Y201302: 113.16,
                              Y201303: 113.40,
                              Y201304: 113.70,
                              Y201305: 113.62,
                              Y201306: 114.22,
                              Y201307: 114.48,
                              Y201308: 114.32
                            },
                            {
                              Cls: '변압기',
                              Y201208: 103.84,
                              Y201209: 103.84,
                              Y201210: 103.84,
                              Y201211: 103.84,
                              Y201212: 103.84,
                              Y201301: 103.75,
                              Y201302: 103.75,
                              Y201303: 103.75,
                              Y201304: 103.75,
                              Y201305: 103.75,
                              Y201306: 103.75,
                              Y201307: 103.75,
                              Y201308: 103.75
                            },
                            {
                              Cls: '전기변환장치',
                              Y201208: 104.18,
                              Y201209: 104.11,
                              Y201210: 103.98,
                              Y201211: 103.98,
                              Y201212: 103.98,
                              Y201301: 103.43,
                              Y201302: 103.43,
                              Y201303: 103.43,
                              Y201304: 103.58,
                              Y201305: 103.16,
                              Y201306: 103.16,
                              Y201307: 103.16,
                              Y201308: 103.16
                            }
                          ]
                        },
                        {
                          Cls: '기타전기장치',
                          Y201208: 101.32,
                          Y201209: 101.74,
                          Y201210: 101.80,
                          Y201211: 101.34,
                          Y201212: 101.36,
                          Y201301: 101.53,
                          Y201302: 101.62,
                          Y201303: 101.42,
                          Y201304: 101.11,
                          Y201305: 100.49,
                          Y201306: 100.33,
                          Y201307: 100.36,
                          Y201308: 100.27,
                          Items: [
                            {
                              Cls: '전기회로개폐및접속장치',
                              Y201208: 100.02,
                              Y201209: 99.93,
                              Y201210: 100.03,
                              Y201211: 100.15,
                              Y201212: 99.94,
                              Y201301: 99.99,
                              Y201302: 99.99,
                              Y201303: 99.96,
                              Y201304: 99.55,
                              Y201305: 99.45,
                              Y201306: 99.40,
                              Y201307: 99.40,
                              Y201308: 99.36
                            },
                            {
                              Cls: '배전반및전기자동제어반',
                              Y201208: 107.47,
                              Y201209: 107.47,
                              Y201210: 107.47,
                              Y201211: 107.47,
                              Y201212: 107.47,
                              Y201301: 108.05,
                              Y201302: 108.05,
                              Y201303: 108.05,
                              Y201304: 108.05,
                              Y201305: 108.05,
                              Y201306: 108.05,
                              Y201307: 108.05,
                              Y201308: 108.05
                            },
                            {
                              Cls: '전지',
                              Y201208: 111.84,
                              Y201209: 111.84,
                              Y201210: 111.84,
                              Y201211: 111.84,
                              Y201212: 111.73,
                              Y201301: 111.93,
                              Y201302: 111.83,
                              Y201303: 111.88,
                              Y201304: 111.88,
                              Y201305: 111.84,
                              Y201306: 111.79,
                              Y201307: 111.76,
                              Y201308: 111.76
                            },
                            {
                              Cls: '전선및케이블',
                              Y201208: 94.29,
                              Y201209: 96.08,
                              Y201210: 96.20,
                              Y201211: 94.70,
                              Y201212: 94.99,
                              Y201301: 95.51,
                              Y201302: 95.96,
                              Y201303: 95.04,
                              Y201304: 94.33,
                              Y201305: 92.44,
                              Y201306: 92.00,
                              Y201307: 92.09,
                              Y201308: 91.84
                            },
                            {
                              Cls: '전구및램프',
                              Y201208: 121.27,
                              Y201209: 117.07,
                              Y201210: 117.07,
                              Y201211: 117.07,
                              Y201212: 117.07,
                              Y201301: 117.07,
                              Y201302: 117.07,
                              Y201303: 117.07,
                              Y201304: 116.15,
                              Y201305: 114.07,
                              Y201306: 113.45,
                              Y201307: 113.45,
                              Y201308: 113.45
                            },
                            {
                              Cls: '조명장치',
                              Y201208: 106.39,
                              Y201209: 106.27,
                              Y201210: 106.27,
                              Y201211: 106.59,
                              Y201212: 106.59,
                              Y201301: 105.72,
                              Y201302: 105.72,
                              Y201303: 106.34,
                              Y201304: 106.34,
                              Y201305: 106.34,
                              Y201306: 106.34,
                              Y201307: 106.32,
                              Y201308: 106.32
                            },
                            {
                              Cls: '기타전기장비',
                              Y201208: 101.63,
                              Y201209: 101.54,
                              Y201210: 101.53,
                              Y201211: 101.24,
                              Y201212: 101.07,
                              Y201301: 101.03,
                              Y201302: 100.81,
                              Y201303: 100.78,
                              Y201304: 100.75,
                              Y201305: 100.91,
                              Y201306: 100.91,
                              Y201307: 100.91,
                              Y201308: 100.89
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '반도체및전자표시장치',
                      Y201208: 78.26,
                      Y201209: 77.82,
                      Y201210: 76.68,
                      Y201211: 75.73,
                      Y201212: 74.79,
                      Y201301: 73.87,
                      Y201302: 75.13,
                      Y201303: 76.18,
                      Y201304: 77.71,
                      Y201305: 78.08,
                      Y201306: 78.25,
                      Y201307: 78.59,
                      Y201308: 77.75,
                      Items: [
                        {
                          Cls: '반도체',
                          Y201208: 83.66,
                          Y201209: 82.98,
                          Y201210: 82.29,
                          Y201211: 81.97,
                          Y201212: 78.67,
                          Y201301: 79.25,
                          Y201302: 81.79,
                          Y201303: 87.71,
                          Y201304: 93.52,
                          Y201305: 93.74,
                          Y201306: 96.11,
                          Y201307: 94.50,
                          Y201308: 92.80,
                          Items: [
                            {
                              Cls: '개별소자',
                              Y201208: 85.75,
                              Y201209: 84.29,
                              Y201210: 83.30,
                              Y201211: 81.41,
                              Y201212: 79.25,
                              Y201301: 78.34,
                              Y201302: 79.42,
                              Y201303: 79.99,
                              Y201304: 80.76,
                              Y201305: 80.22,
                              Y201306: 80.88,
                              Y201307: 80.45,
                              Y201308: 80.15
                            },
                            {
                              Cls: '집적회로',
                              Y201208: 72.19,
                              Y201209: 72.12,
                              Y201210: 71.70,
                              Y201211: 72.48,
                              Y201212: 68.82,
                              Y201301: 70.35,
                              Y201302: 73.60,
                              Y201303: 82.47,
                              Y201304: 91.03,
                              Y201305: 91.74,
                              Y201306: 95.01,
                              Y201307: 92.77,
                              Y201308: 90.33
                            }
                          ]
                        },
                        {
                          Cls: '전자표시장치',
                          Y201208: 75.04,
                          Y201209: 74.68,
                          Y201210: 73.46,
                          Y201211: 72.37,
                          Y201212: 72.03,
                          Y201301: 70.89,
                          Y201302: 71.91,
                          Y201303: 72.12,
                          Y201304: 72.89,
                          Y201305: 73.28,
                          Y201306: 73.10,
                          Y201307: 73.74,
                          Y201308: 73.07,
                          Items: [
                            {
                              Cls: 'LCD평판디스플레이',
                              Y201208: 74.41,
                              Y201209: 74.02,
                              Y201210: 72.71,
                              Y201211: 71.55,
                              Y201212: 71.17,
                              Y201301: 69.84,
                              Y201302: 71.03,
                              Y201303: 71.28,
                              Y201304: 72.18,
                              Y201305: 72.64,
                              Y201306: 72.41,
                              Y201307: 73.17,
                              Y201308: 72.38
                            },
                            {
                              Cls: '기타전자표시장치',
                              Y201208: 85.53,
                              Y201209: 85.53,
                              Y201210: 85.53,
                              Y201211: 85.53,
                              Y201212: 85.53,
                              Y201301: 85.53,
                              Y201302: 85.53,
                              Y201303: 85.53,
                              Y201304: 85.53,
                              Y201305: 85.53,
                              Y201306: 85.53,
                              Y201307: 85.53,
                              Y201308: 85.53
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '기타전자부품',
                      Y201208: 97.46,
                      Y201209: 95.81,
                      Y201210: 93.28,
                      Y201211: 92.27,
                      Y201212: 91.81,
                      Y201301: 90.60,
                      Y201302: 91.42,
                      Y201303: 91.83,
                      Y201304: 92.56,
                      Y201305: 92.26,
                      Y201306: 92.82,
                      Y201307: 92.56,
                      Y201308: 92.23,
                      Items: [
                        {
                          Cls: '기타전자부분품',
                          Y201208: 97.46,
                          Y201209: 95.81,
                          Y201210: 93.28,
                          Y201211: 92.27,
                          Y201212: 91.81,
                          Y201301: 90.60,
                          Y201302: 91.42,
                          Y201303: 91.83,
                          Y201304: 92.56,
                          Y201305: 92.26,
                          Y201306: 92.82,
                          Y201307: 92.56,
                          Y201308: 92.23,
                          Items: [
                            {
                              Cls: '축전기,저항기,전자코일및변성기',
                              Y201208: 101.22,
                              Y201209: 100.44,
                              Y201210: 100.22,
                              Y201211: 99.26,
                              Y201212: 99.12,
                              Y201301: 98.31,
                              Y201302: 98.78,
                              Y201303: 98.06,
                              Y201304: 98.06,
                              Y201305: 97.38,
                              Y201306: 97.71,
                              Y201307: 97.60,
                              Y201308: 97.16
                            },
                            {
                              Cls: '인쇄회로기판',
                              Y201208: 96.79,
                              Y201209: 94.49,
                              Y201210: 90.78,
                              Y201211: 89.54,
                              Y201212: 88.92,
                              Y201301: 87.61,
                              Y201302: 88.69,
                              Y201303: 89.44,
                              Y201304: 90.52,
                              Y201305: 90.24,
                              Y201306: 90.95,
                              Y201307: 90.57,
                              Y201308: 90.17
                            },
                            {
                              Cls: '기타전자부품',
                              Y201208: 96.78,
                              Y201209: 96.78,
                              Y201210: 96.63,
                              Y201211: 96.47,
                              Y201212: 96.28,
                              Y201301: 95.08,
                              Y201302: 95.30,
                              Y201303: 95.45,
                              Y201304: 95.65,
                              Y201305: 95.54,
                              Y201306: 95.79,
                              Y201307: 95.79,
                              Y201308: 95.79
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '컴퓨터및주변기기',
                      Y201208: 82.18,
                      Y201209: 82.43,
                      Y201210: 82.34,
                      Y201211: 82.41,
                      Y201212: 81.61,
                      Y201301: 81.67,
                      Y201302: 81.77,
                      Y201303: 82.65,
                      Y201304: 82.61,
                      Y201305: 81.90,
                      Y201306: 81.90,
                      Y201307: 81.82,
                      Y201308: 81.90,
                      Items: [
                        {
                          Cls: '컴퓨터및주변기기',
                          Y201208: 82.18,
                          Y201209: 82.43,
                          Y201210: 82.34,
                          Y201211: 82.41,
                          Y201212: 81.61,
                          Y201301: 81.67,
                          Y201302: 81.77,
                          Y201303: 82.65,
                          Y201304: 82.61,
                          Y201305: 81.90,
                          Y201306: 81.90,
                          Y201307: 81.82,
                          Y201308: 81.90,
                          Items: [
                            {
                              Cls: '컴퓨터',
                              Y201208: 80.13,
                              Y201209: 79.18,
                              Y201210: 78.37,
                              Y201211: 78.37,
                              Y201212: 77.17,
                              Y201301: 77.00,
                              Y201302: 76.94,
                              Y201303: 77.50,
                              Y201304: 77.72,
                              Y201305: 76.13,
                              Y201306: 75.58,
                              Y201307: 75.52,
                              Y201308: 76.25
                            },
                            {
                              Cls: '컴퓨터기억장치',
                              Y201208: 72.64,
                              Y201209: 73.44,
                              Y201210: 73.45,
                              Y201211: 73.60,
                              Y201212: 73.12,
                              Y201301: 73.30,
                              Y201302: 73.52,
                              Y201303: 75.18,
                              Y201304: 75.85,
                              Y201305: 74.87,
                              Y201306: 75.06,
                              Y201307: 74.90,
                              Y201308: 74.85
                            },
                            {
                              Cls: '컴퓨터주변기기',
                              Y201208: 91.92,
                              Y201209: 91.92,
                              Y201210: 91.92,
                              Y201211: 91.92,
                              Y201212: 90.94,
                              Y201301: 90.94,
                              Y201302: 90.94,
                              Y201303: 90.94,
                              Y201304: 89.92,
                              Y201305: 89.92,
                              Y201306: 89.92,
                              Y201307: 89.92,
                              Y201308: 89.92
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '통신,영상및음향기기',
                      Y201208: 95.97,
                      Y201209: 95.92,
                      Y201210: 95.87,
                      Y201211: 93.47,
                      Y201212: 93.43,
                      Y201301: 92.94,
                      Y201302: 92.93,
                      Y201303: 92.94,
                      Y201304: 91.23,
                      Y201305: 90.34,
                      Y201306: 89.66,
                      Y201307: 89.38,
                      Y201308: 89.98,
                      Items: [
                        {
                          Cls: '통신및방송장비',
                          Y201208: 96.51,
                          Y201209: 96.51,
                          Y201210: 96.50,
                          Y201211: 93.24,
                          Y201212: 93.24,
                          Y201301: 92.68,
                          Y201302: 92.67,
                          Y201303: 92.67,
                          Y201304: 90.57,
                          Y201305: 89.50,
                          Y201306: 89.05,
                          Y201307: 89.11,
                          Y201308: 89.91,
                          Items: [
                            {
                              Cls: '유선통신기기',
                              Y201208: 101.71,
                              Y201209: 101.71,
                              Y201210: 101.71,
                              Y201211: 101.71,
                              Y201212: 101.71,
                              Y201301: 101.71,
                              Y201302: 101.71,
                              Y201303: 101.71,
                              Y201304: 99.80,
                              Y201305: 99.80,
                              Y201306: 99.80,
                              Y201307: 99.80,
                              Y201308: 99.80
                            },
                            {
                              Cls: '이동전화기',
                              Y201208: 94.17,
                              Y201209: 94.17,
                              Y201210: 94.16,
                              Y201211: 91.78,
                              Y201212: 91.78,
                              Y201301: 91.09,
                              Y201302: 91.09,
                              Y201303: 91.09,
                              Y201304: 88.73,
                              Y201305: 87.44,
                              Y201306: 86.99,
                              Y201307: 87.06,
                              Y201308: 88.04
                            },
                            {
                              Cls: '기타무선통신장비 및 방송장비',
                              Y201208: 97.55,
                              Y201209: 97.55,
                              Y201210: 97.55,
                              Y201211: 89.22,
                              Y201212: 89.22,
                              Y201301: 89.22,
                              Y201302: 89.22,
                              Y201303: 89.22,
                              Y201304: 88.87,
                              Y201305: 88.81,
                              Y201306: 88.14,
                              Y201307: 88.14,
                              Y201308: 88.14
                            }
                          ]
                        },
                        {
                          Cls: '영상및음향기기',
                          Y201208: 95.10,
                          Y201209: 94.92,
                          Y201210: 94.76,
                          Y201211: 94.52,
                          Y201212: 94.39,
                          Y201301: 94.23,
                          Y201302: 94.21,
                          Y201303: 94.24,
                          Y201304: 94.31,
                          Y201305: 94.19,
                          Y201306: 92.45,
                          Y201307: 90.65,
                          Y201308: 90.41,
                          Items: [
                            {
                              Cls: 'TV',
                              Y201208: 91.50,
                              Y201209: 91.40,
                              Y201210: 91.16,
                              Y201211: 90.89,
                              Y201212: 90.73,
                              Y201301: 90.54,
                              Y201302: 90.54,
                              Y201303: 90.54,
                              Y201304: 90.60,
                              Y201305: 90.51,
                              Y201306: 88.02,
                              Y201307: 85.54,
                              Y201308: 85.39
                            },
                            {
                              Cls: '영상기기',
                              Y201208: 97.03,
                              Y201209: 97.03,
                              Y201210: 96.92,
                              Y201211: 96.92,
                              Y201212: 96.92,
                              Y201301: 96.92,
                              Y201302: 96.92,
                              Y201303: 96.93,
                              Y201304: 96.93,
                              Y201305: 96.13,
                              Y201306: 96.13,
                              Y201307: 96.13,
                              Y201308: 96.13
                            },
                            {
                              Cls: '오디오및음향기기',
                              Y201208: 103.08,
                              Y201209: 102.68,
                              Y201210: 102.76,
                              Y201211: 102.55,
                              Y201212: 102.43,
                              Y201301: 102.34,
                              Y201302: 102.24,
                              Y201303: 102.36,
                              Y201304: 102.47,
                              Y201305: 102.38,
                              Y201306: 102.57,
                              Y201307: 102.49,
                              Y201308: 101.97
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '가정용전기기기',
                      Y201208: 100.22,
                      Y201209: 100.22,
                      Y201210: 100.30,
                      Y201211: 100.30,
                      Y201212: 100.00,
                      Y201301: 100.00,
                      Y201302: 100.00,
                      Y201303: 100.00,
                      Y201304: 100.00,
                      Y201305: 100.09,
                      Y201306: 100.09,
                      Y201307: 100.07,
                      Y201308: 99.96,
                      Items: [
                        {
                          Cls: '가정용전기기기',
                          Y201208: 100.22,
                          Y201209: 100.22,
                          Y201210: 100.30,
                          Y201211: 100.30,
                          Y201212: 100.00,
                          Y201301: 100.00,
                          Y201302: 100.00,
                          Y201303: 100.00,
                          Y201304: 100.00,
                          Y201305: 100.09,
                          Y201306: 100.09,
                          Y201307: 100.07,
                          Y201308: 99.96,
                          Items: [
                            {
                              Cls: '가정용냉장고및냉동고',
                              Y201208: 100.63,
                              Y201209: 100.63,
                              Y201210: 100.63,
                              Y201211: 100.63,
                              Y201212: 99.90,
                              Y201301: 99.90,
                              Y201302: 99.90,
                              Y201303: 99.90,
                              Y201304: 99.90,
                              Y201305: 99.90,
                              Y201306: 99.90,
                              Y201307: 99.90,
                              Y201308: 99.90
                            },
                            {
                              Cls: '주방용및난방용전기기기',
                              Y201208: 102.69,
                              Y201209: 102.69,
                              Y201210: 103.04,
                              Y201211: 103.04,
                              Y201212: 103.04,
                              Y201301: 103.04,
                              Y201302: 103.04,
                              Y201303: 103.04,
                              Y201304: 103.04,
                              Y201305: 103.37,
                              Y201306: 103.37,
                              Y201307: 103.92,
                              Y201308: 103.49
                            },
                            {
                              Cls: '기타가정용전기기기',
                              Y201208: 98.85,
                              Y201209: 98.85,
                              Y201210: 98.85,
                              Y201211: 98.85,
                              Y201212: 98.85,
                              Y201301: 98.85,
                              Y201302: 98.85,
                              Y201303: 98.85,
                              Y201304: 98.85,
                              Y201305: 98.85,
                              Y201306: 98.85,
                              Y201307: 98.33,
                              Y201308: 98.33
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '정밀기기',
                  Y201208: 99.98,
                  Y201209: 99.98,
                  Y201210: 100.03,
                  Y201211: 100.03,
                  Y201212: 99.80,
                  Y201301: 99.49,
                  Y201302: 99.44,
                  Y201303: 99.23,
                  Y201304: 99.23,
                  Y201305: 99.23,
                  Y201306: 99.23,
                  Y201307: 99.22,
                  Y201308: 99.22,
                  Items: [
                    {
                      Cls: '정밀기기',
                      Y201208: 99.98,
                      Y201209: 99.98,
                      Y201210: 100.03,
                      Y201211: 100.03,
                      Y201212: 99.80,
                      Y201301: 99.49,
                      Y201302: 99.44,
                      Y201303: 99.23,
                      Y201304: 99.23,
                      Y201305: 99.23,
                      Y201306: 99.23,
                      Y201307: 99.22,
                      Y201308: 99.22,
                      Items: [
                        {
                          Cls: '의료및측정기기',
                          Y201208: 102.53,
                          Y201209: 102.53,
                          Y201210: 102.61,
                          Y201211: 102.61,
                          Y201212: 102.61,
                          Y201301: 102.65,
                          Y201302: 102.74,
                          Y201303: 102.74,
                          Y201304: 102.74,
                          Y201305: 102.74,
                          Y201306: 102.74,
                          Y201307: 102.73,
                          Y201308: 102.73,
                          Items: [
                            {
                              Cls: '의료용기기',
                              Y201208: 100.84,
                              Y201209: 100.84,
                              Y201210: 100.84,
                              Y201211: 100.84,
                              Y201212: 100.84,
                              Y201301: 100.84,
                              Y201302: 100.84,
                              Y201303: 100.84,
                              Y201304: 100.84,
                              Y201305: 100.84,
                              Y201306: 100.84,
                              Y201307: 100.84,
                              Y201308: 100.84
                            },
                            {
                              Cls: '측정및분석기',
                              Y201208: 100.90,
                              Y201209: 100.90,
                              Y201210: 101.08,
                              Y201211: 101.08,
                              Y201212: 101.08,
                              Y201301: 101.19,
                              Y201302: 101.44,
                              Y201303: 101.44,
                              Y201304: 101.44,
                              Y201305: 101.44,
                              Y201306: 101.44,
                              Y201307: 101.43,
                              Y201308: 101.43
                            },
                            {
                              Cls: '자동조정및제어기기',
                              Y201208: 105.55,
                              Y201209: 105.55,
                              Y201210: 105.55,
                              Y201211: 105.55,
                              Y201212: 105.55,
                              Y201301: 105.55,
                              Y201302: 105.55,
                              Y201303: 105.55,
                              Y201304: 105.55,
                              Y201305: 105.55,
                              Y201306: 105.55,
                              Y201307: 105.55,
                              Y201308: 105.55
                            }
                          ]
                        },
                        {
                          Cls: '기타정밀기기',
                          Y201208: 92.43,
                          Y201209: 92.43,
                          Y201210: 92.43,
                          Y201211: 92.43,
                          Y201212: 91.67,
                          Y201301: 90.62,
                          Y201302: 90.29,
                          Y201303: 89.61,
                          Y201304: 89.61,
                          Y201305: 89.61,
                          Y201306: 89.61,
                          Y201307: 89.61,
                          Y201308: 89.61,
                          Items: [
                            {
                              Cls: '사진기및영사기',
                              Y201208: 92.13,
                              Y201209: 92.13,
                              Y201210: 92.13,
                              Y201211: 92.13,
                              Y201212: 91.05,
                              Y201301: 90.49,
                              Y201302: 90.00,
                              Y201303: 89.00,
                              Y201304: 89.00,
                              Y201305: 89.00,
                              Y201306: 89.00,
                              Y201307: 89.00,
                              Y201308: 89.00
                            },
                            {
                              Cls: '안경및기타광학기기',
                              Y201208: 93.82,
                              Y201209: 93.82,
                              Y201210: 93.82,
                              Y201211: 93.82,
                              Y201212: 93.82,
                              Y201301: 91.73,
                              Y201302: 91.73,
                              Y201303: 91.73,
                              Y201304: 91.73,
                              Y201305: 91.73,
                              Y201306: 91.73,
                              Y201307: 91.73,
                              Y201308: 91.73
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '수송장비',
                  Y201208: 102.38,
                  Y201209: 102.37,
                  Y201210: 102.41,
                  Y201211: 102.44,
                  Y201212: 102.06,
                  Y201301: 102.49,
                  Y201302: 102.15,
                  Y201303: 102.38,
                  Y201304: 102.29,
                  Y201305: 102.44,
                  Y201306: 102.45,
                  Y201307: 102.50,
                  Y201308: 102.51,
                  Items: [
                    {
                      Cls: '자동차',
                      Y201208: 102.34,
                      Y201209: 102.33,
                      Y201210: 102.38,
                      Y201211: 102.40,
                      Y201212: 102.02,
                      Y201301: 102.45,
                      Y201302: 102.11,
                      Y201303: 102.34,
                      Y201304: 102.25,
                      Y201305: 102.40,
                      Y201306: 102.41,
                      Y201307: 102.47,
                      Y201308: 102.47,
                      Items: [
                        {
                          Cls: '자동차',
                          Y201208: 102.22,
                          Y201209: 102.18,
                          Y201210: 102.20,
                          Y201211: 102.51,
                          Y201212: 102.55,
                          Y201301: 102.76,
                          Y201302: 102.74,
                          Y201303: 102.77,
                          Y201304: 102.58,
                          Y201305: 102.69,
                          Y201306: 102.73,
                          Y201307: 102.69,
                          Y201308: 102.70,
                          Items: [
                            {
                              Cls: '승용차',
                              Y201208: 101.22,
                              Y201209: 101.16,
                              Y201210: 101.18,
                              Y201211: 101.64,
                              Y201212: 101.64,
                              Y201301: 101.94,
                              Y201302: 101.93,
                              Y201303: 101.98,
                              Y201304: 101.69,
                              Y201305: 101.85,
                              Y201306: 101.91,
                              Y201307: 101.82,
                              Y201308: 101.84
                            },
                            {
                              Cls: '버스',
                              Y201208: 106.75,
                              Y201209: 106.75,
                              Y201210: 106.80,
                              Y201211: 106.80,
                              Y201212: 106.96,
                              Y201301: 106.96,
                              Y201302: 106.96,
                              Y201303: 106.96,
                              Y201304: 106.96,
                              Y201305: 106.96,
                              Y201306: 106.96,
                              Y201307: 106.96,
                              Y201308: 106.96
                            },
                            {
                              Cls: '트럭',
                              Y201208: 102.39,
                              Y201209: 102.39,
                              Y201210: 102.39,
                              Y201211: 102.39,
                              Y201212: 102.39,
                              Y201301: 102.39,
                              Y201302: 102.39,
                              Y201303: 102.39,
                              Y201304: 102.39,
                              Y201305: 102.39,
                              Y201306: 102.39,
                              Y201307: 102.52,
                              Y201308: 102.52
                            },
                            {
                              Cls: '특장차',
                              Y201208: 102.51,
                              Y201209: 102.51,
                              Y201210: 102.51,
                              Y201211: 102.51,
                              Y201212: 102.51,
                              Y201301: 102.51,
                              Y201302: 102.51,
                              Y201303: 102.51,
                              Y201304: 102.51,
                              Y201305: 102.51,
                              Y201306: 102.51,
                              Y201307: 102.75,
                              Y201308: 102.75
                            }
                          ]
                        },
                        {
                          Cls: '자동차용엔진및부분품',
                          Y201208: 102.43,
                          Y201209: 102.43,
                          Y201210: 102.48,
                          Y201211: 102.38,
                          Y201212: 101.83,
                          Y201301: 102.36,
                          Y201302: 101.88,
                          Y201303: 102.20,
                          Y201304: 102.16,
                          Y201305: 102.31,
                          Y201306: 102.31,
                          Y201307: 102.41,
                          Y201308: 102.41,
                          Items: [
                            {
                              Cls: '자동차용엔진',
                              Y201208: 100.83,
                              Y201209: 100.83,
                              Y201210: 100.83,
                              Y201211: 100.83,
                              Y201212: 100.83,
                              Y201301: 102.55,
                              Y201302: 102.55,
                              Y201303: 102.55,
                              Y201304: 102.55,
                              Y201305: 102.55,
                              Y201306: 102.55,
                              Y201307: 102.55,
                              Y201308: 102.55
                            },
                            {
                              Cls: '자동차부분품',
                              Y201208: 102.82,
                              Y201209: 102.82,
                              Y201210: 102.89,
                              Y201211: 102.77,
                              Y201212: 102.08,
                              Y201301: 102.34,
                              Y201302: 101.74,
                              Y201303: 102.13,
                              Y201304: 102.08,
                              Y201305: 102.26,
                              Y201306: 102.26,
                              Y201307: 102.40,
                              Y201308: 102.40
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '기타수송장비',
                      Y201208: 107.90,
                      Y201209: 107.90,
                      Y201210: 107.90,
                      Y201211: 107.90,
                      Y201212: 107.90,
                      Y201301: 107.90,
                      Y201302: 107.90,
                      Y201303: 107.90,
                      Y201304: 107.90,
                      Y201305: 107.90,
                      Y201306: 107.90,
                      Y201307: 107.90,
                      Y201308: 107.90,
                      Items: [
                        {
                          Cls: '기타수송장비',
                          Y201208: 107.90,
                          Y201209: 107.90,
                          Y201210: 107.90,
                          Y201211: 107.90,
                          Y201212: 107.90,
                          Y201301: 107.90,
                          Y201302: 107.90,
                          Y201303: 107.90,
                          Y201304: 107.90,
                          Y201305: 107.90,
                          Y201306: 107.90,
                          Y201307: 107.90,
                          Y201308: 107.90,
                          Items: [
                            {
                              Cls: '모터사이클',
                              Y201208: 107.90,
                              Y201209: 107.90,
                              Y201210: 107.90,
                              Y201211: 107.90,
                              Y201212: 107.90,
                              Y201301: 107.90,
                              Y201302: 107.90,
                              Y201303: 107.90,
                              Y201304: 107.90,
                              Y201305: 107.90,
                              Y201306: 107.90,
                              Y201307: 107.90,
                              Y201308: 107.90
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '기타제조업제품',
                  Y201208: 107.08,
                  Y201209: 107.08,
                  Y201210: 106.43,
                  Y201211: 106.40,
                  Y201212: 106.40,
                  Y201301: 110.43,
                  Y201302: 110.53,
                  Y201303: 110.84,
                  Y201304: 110.89,
                  Y201305: 110.93,
                  Y201306: 110.92,
                  Y201307: 110.90,
                  Y201308: 110.91,
                  Items: [
                    {
                      Cls: '기타제조업제품',
                      Y201208: 107.08,
                      Y201209: 107.08,
                      Y201210: 106.43,
                      Y201211: 106.40,
                      Y201212: 106.40,
                      Y201301: 110.43,
                      Y201302: 110.53,
                      Y201303: 110.84,
                      Y201304: 110.89,
                      Y201305: 110.93,
                      Y201306: 110.92,
                      Y201307: 110.90,
                      Y201308: 110.91,
                      Items: [
                        {
                          Cls: '가구',
                          Y201208: 108.78,
                          Y201209: 108.78,
                          Y201210: 107.93,
                          Y201211: 107.93,
                          Y201212: 107.97,
                          Y201301: 113.30,
                          Y201302: 113.30,
                          Y201303: 113.68,
                          Y201304: 113.71,
                          Y201305: 113.72,
                          Y201306: 113.71,
                          Y201307: 113.68,
                          Y201308: 113.68,
                          Items: [
                            {
                              Cls: '목재가구',
                              Y201208: 103.16,
                              Y201209: 103.16,
                              Y201210: 102.61,
                              Y201211: 102.61,
                              Y201212: 102.61,
                              Y201301: 102.61,
                              Y201302: 102.61,
                              Y201303: 103.52,
                              Y201304: 103.52,
                              Y201305: 103.52,
                              Y201306: 103.52,
                              Y201307: 103.53,
                              Y201308: 103.53
                            },
                            {
                              Cls: '금속가구',
                              Y201208: 103.95,
                              Y201209: 103.95,
                              Y201210: 103.95,
                              Y201211: 103.95,
                              Y201212: 104.15,
                              Y201301: 104.15,
                              Y201302: 104.15,
                              Y201303: 104.37,
                              Y201304: 104.37,
                              Y201305: 104.37,
                              Y201306: 104.37,
                              Y201307: 104.37,
                              Y201308: 104.37
                            },
                            {
                              Cls: '기타가구',
                              Y201208: 115.46,
                              Y201209: 115.46,
                              Y201210: 114.12,
                              Y201211: 114.12,
                              Y201212: 114.15,
                              Y201301: 124.97,
                              Y201302: 124.97,
                              Y201303: 124.94,
                              Y201304: 125.01,
                              Y201305: 125.02,
                              Y201306: 124.99,
                              Y201307: 124.91,
                              Y201308: 124.93
                            }
                          ]
                        },
                        {
                          Cls: '장난감및운동용품',
                          Y201208: 101.36,
                          Y201209: 101.36,
                          Y201210: 101.36,
                          Y201211: 101.36,
                          Y201212: 101.36,
                          Y201301: 101.36,
                          Y201302: 101.36,
                          Y201303: 101.36,
                          Y201304: 101.36,
                          Y201305: 101.36,
                          Y201306: 101.36,
                          Y201307: 101.36,
                          Y201308: 101.36,
                          Items: [
                            {
                              Cls: '운동및경기용품',
                              Y201208: 101.36,
                              Y201209: 101.36,
                              Y201210: 101.36,
                              Y201211: 101.36,
                              Y201212: 101.36,
                              Y201301: 101.36,
                              Y201302: 101.36,
                              Y201303: 101.36,
                              Y201304: 101.36,
                              Y201305: 101.36,
                              Y201306: 101.36,
                              Y201307: 101.36,
                              Y201308: 101.36
                            }
                          ]
                        },
                        {
                          Cls: '기타제조업제품',
                          Y201208: 101.81,
                          Y201209: 101.77,
                          Y201210: 101.74,
                          Y201211: 101.61,
                          Y201212: 101.49,
                          Y201301: 101.38,
                          Y201302: 101.91,
                          Y201303: 101.99,
                          Y201304: 102.15,
                          Y201305: 102.38,
                          Y201306: 102.34,
                          Y201307: 102.38,
                          Y201308: 102.38,
                          Items: [
                            {
                              Cls: '모형및장식용품',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 100.00,
                              Y201301: 100.00,
                              Y201302: 100.00,
                              Y201303: 100.00,
                              Y201304: 100.00,
                              Y201305: 100.00,
                              Y201306: 100.00,
                              Y201307: 100.00,
                              Y201308: 100.00
                            },
                            {
                              Cls: '기타제조업제품',
                              Y201208: 106.47,
                              Y201209: 106.37,
                              Y201210: 106.25,
                              Y201211: 105.84,
                              Y201212: 105.43,
                              Y201301: 105.12,
                              Y201302: 106.59,
                              Y201303: 106.82,
                              Y201304: 107.26,
                              Y201305: 107.91,
                              Y201306: 107.80,
                              Y201307: 107.91,
                              Y201308: 107.91
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              Cls: '전력,가스및수도',
              Y201208: 115.43,
              Y201209: 115.41,
              Y201210: 115.47,
              Y201211: 115.34,
              Y201212: 115.32,
              Y201301: 116.72,
              Y201302: 118.55,
              Y201303: 120.19,
              Y201304: 120.15,
              Y201305: 119.99,
              Y201306: 119.90,
              Y201307: 120.05,
              Y201308: 120.37,
              Items: [
                {
                  Cls: '전력,가스및수도',
                  Y201208: 115.43,
                  Y201209: 115.41,
                  Y201210: 115.47,
                  Y201211: 115.34,
                  Y201212: 115.32,
                  Y201301: 116.72,
                  Y201302: 118.55,
                  Y201303: 120.19,
                  Y201304: 120.15,
                  Y201305: 119.99,
                  Y201306: 119.90,
                  Y201307: 120.05,
                  Y201308: 120.37,
                  Items: [
                    {
                      Cls: '전력및신재생에너지',
                      Y201208: 115.74,
                      Y201209: 115.74,
                      Y201210: 115.74,
                      Y201211: 115.74,
                      Y201212: 115.74,
                      Y201301: 118.27,
                      Y201302: 120.87,
                      Y201303: 120.87,
                      Y201304: 120.87,
                      Y201305: 120.87,
                      Y201306: 120.87,
                      Y201307: 120.87,
                      Y201308: 120.87,
                      Items: [
                        {
                          Cls: '전력및신재생에너지',
                          Y201208: 115.74,
                          Y201209: 115.74,
                          Y201210: 115.74,
                          Y201211: 115.74,
                          Y201212: 115.74,
                          Y201301: 118.27,
                          Y201302: 120.87,
                          Y201303: 120.87,
                          Y201304: 120.87,
                          Y201305: 120.87,
                          Y201306: 120.87,
                          Y201307: 120.87,
                          Y201308: 120.87,
                          Items: [
                            {
                              Cls: '전력',
                              Y201208: 115.74,
                              Y201209: 115.74,
                              Y201210: 115.74,
                              Y201211: 115.74,
                              Y201212: 115.74,
                              Y201301: 118.27,
                              Y201302: 120.87,
                              Y201303: 120.87,
                              Y201304: 120.87,
                              Y201305: 120.87,
                              Y201306: 120.87,
                              Y201307: 120.87,
                              Y201308: 120.87
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '도시가스및수도',
                      Y201208: 114.64,
                      Y201209: 114.60,
                      Y201210: 114.75,
                      Y201211: 114.43,
                      Y201212: 114.37,
                      Y201301: 114.42,
                      Y201302: 115.34,
                      Y201303: 118.91,
                      Y201304: 118.83,
                      Y201305: 118.50,
                      Y201306: 118.27,
                      Y201307: 118.62,
                      Y201308: 119.31,
                      Items: [
                        {
                          Cls: '도시가스및수도',
                          Y201208: 114.64,
                          Y201209: 114.60,
                          Y201210: 114.75,
                          Y201211: 114.43,
                          Y201212: 114.37,
                          Y201301: 114.42,
                          Y201302: 115.34,
                          Y201303: 118.91,
                          Y201304: 118.83,
                          Y201305: 118.50,
                          Y201306: 118.27,
                          Y201307: 118.62,
                          Y201308: 119.31,
                          Items: [
                            {
                              Cls: '도시가스',
                              Y201208: 115.78,
                              Y201209: 115.78,
                              Y201210: 115.78,
                              Y201211: 115.78,
                              Y201212: 115.78,
                              Y201301: 115.78,
                              Y201302: 117.11,
                              Y201303: 121.12,
                              Y201304: 121.12,
                              Y201305: 121.12,
                              Y201306: 121.12,
                              Y201307: 121.12,
                              Y201308: 121.82
                            },
                            {
                              Cls: '증기및온수공급업',
                              Y201208: 110.04,
                              Y201209: 109.62,
                              Y201210: 111.11,
                              Y201211: 108.02,
                              Y201212: 107.01,
                              Y201301: 107.57,
                              Y201302: 106.36,
                              Y201303: 108.54,
                              Y201304: 107.77,
                              Y201305: 104.27,
                              Y201306: 101.76,
                              Y201307: 105.18,
                              Y201308: 106.56
                            },
                            {
                              Cls: '수도',
                              Y201208: 109.95,
                              Y201209: 109.95,
                              Y201210: 109.95,
                              Y201211: 109.95,
                              Y201212: 110.28,
                              Y201301: 110.26,
                              Y201302: 110.26,
                              Y201303: 112.10,
                              Y201304: 112.01,
                              Y201305: 112.01,
                              Y201306: 112.14,
                              Y201307: 112.33,
                              Y201308: 112.39
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              Cls: '서비스',
              Y201208: 104.31,
              Y201209: 104.23,
              Y201210: 104.40,
              Y201211: 104.37,
              Y201212: 104.31,
              Y201301: 104.04,
              Y201302: 104.15,
              Y201303: 104.30,
              Y201304: 104.28,
              Y201305: 104.38,
              Y201306: 104.36,
              Y201307: 104.54,
              Y201308: 104.73,
              Items: [
                {
                  Cls: '음식점및숙박',
                  Y201208: 110.11,
                  Y201209: 109.47,
                  Y201210: 109.63,
                  Y201211: 109.62,
                  Y201212: 110.08,
                  Y201301: 110.62,
                  Y201302: 110.88,
                  Y201303: 110.69,
                  Y201304: 110.91,
                  Y201305: 111.06,
                  Y201306: 111.16,
                  Y201307: 111.52,
                  Y201308: 111.86,
                  Items: [
                    {
                      Cls: '음식점및숙박',
                      Y201208: 110.11,
                      Y201209: 109.47,
                      Y201210: 109.63,
                      Y201211: 109.62,
                      Y201212: 110.08,
                      Y201301: 110.62,
                      Y201302: 110.88,
                      Y201303: 110.69,
                      Y201304: 110.91,
                      Y201305: 111.06,
                      Y201306: 111.16,
                      Y201307: 111.52,
                      Y201308: 111.86,
                      Items: [
                        {
                          Cls: '음식점',
                          Y201208: 109.28,
                          Y201209: 109.40,
                          Y201210: 109.51,
                          Y201211: 109.54,
                          Y201212: 109.64,
                          Y201301: 109.98,
                          Y201302: 110.29,
                          Y201303: 110.62,
                          Y201304: 110.79,
                          Y201305: 110.92,
                          Y201306: 111.02,
                          Y201307: 111.07,
                          Y201308: 111.14,
                          Items: [
                            {
                              Cls: '일반음식점',
                              Y201208: 110.35,
                              Y201209: 110.41,
                              Y201210: 110.47,
                              Y201211: 110.60,
                              Y201212: 110.66,
                              Y201301: 111.04,
                              Y201302: 111.39,
                              Y201303: 111.78,
                              Y201304: 111.95,
                              Y201305: 112.10,
                              Y201306: 112.19,
                              Y201307: 112.23,
                              Y201308: 112.33
                            },
                            {
                              Cls: '기타음식점',
                              Y201208: 105.50,
                              Y201209: 105.80,
                              Y201210: 106.09,
                              Y201211: 105.79,
                              Y201212: 106.00,
                              Y201301: 106.24,
                              Y201302: 106.37,
                              Y201303: 106.50,
                              Y201304: 106.65,
                              Y201305: 106.74,
                              Y201306: 106.90,
                              Y201307: 106.90,
                              Y201308: 106.91
                            }
                          ]
                        },
                        {
                          Cls: '숙박',
                          Y201208: 123.04,
                          Y201209: 110.35,
                          Y201210: 111.35,
                          Y201211: 110.79,
                          Y201212: 116.80,
                          Y201301: 120.11,
                          Y201302: 119.95,
                          Y201303: 112.01,
                          Y201304: 112.85,
                          Y201305: 113.33,
                          Y201306: 113.45,
                          Y201307: 118.49,
                          Y201308: 122.71,
                          Items: [
                            {
                              Cls: '숙박',
                              Y201208: 123.04,
                              Y201209: 110.35,
                              Y201210: 111.35,
                              Y201211: 110.79,
                              Y201212: 116.80,
                              Y201301: 120.11,
                              Y201302: 119.95,
                              Y201303: 112.01,
                              Y201304: 112.85,
                              Y201305: 113.33,
                              Y201306: 113.45,
                              Y201307: 118.49,
                              Y201308: 122.71
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '운수',
                  Y201208: 103.95,
                  Y201209: 103.25,
                  Y201210: 104.00,
                  Y201211: 103.93,
                  Y201212: 103.42,
                  Y201301: 103.36,
                  Y201302: 103.20,
                  Y201303: 103.85,
                  Y201304: 103.88,
                  Y201305: 103.89,
                  Y201306: 104.04,
                  Y201307: 104.75,
                  Y201308: 104.94,
                  Items: [
                    {
                      Cls: '육상운송',
                      Y201208: 105.11,
                      Y201209: 105.20,
                      Y201210: 106.15,
                      Y201211: 105.87,
                      Y201212: 105.33,
                      Y201301: 105.86,
                      Y201302: 106.05,
                      Y201303: 107.31,
                      Y201304: 107.59,
                      Y201305: 107.74,
                      Y201306: 107.55,
                      Y201307: 107.66,
                      Y201308: 107.66,
                      Items: [
                        {
                          Cls: '철도운송',
                          Y201208: 109.05,
                          Y201209: 109.05,
                          Y201210: 109.05,
                          Y201211: 109.05,
                          Y201212: 109.05,
                          Y201301: 109.05,
                          Y201302: 109.05,
                          Y201303: 109.05,
                          Y201304: 109.05,
                          Y201305: 109.05,
                          Y201306: 109.05,
                          Y201307: 109.05,
                          Y201308: 109.05,
                          Items: [
                            {
                              Cls: '철도여객운송',
                              Y201208: 109.90,
                              Y201209: 109.90,
                              Y201210: 109.90,
                              Y201211: 109.90,
                              Y201212: 109.90,
                              Y201301: 109.90,
                              Y201302: 109.90,
                              Y201303: 109.90,
                              Y201304: 109.90,
                              Y201305: 109.90,
                              Y201306: 109.90,
                              Y201307: 109.90,
                              Y201308: 109.90
                            },
                            {
                              Cls: '철도화물운송',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 100.00,
                              Y201301: 100.00,
                              Y201302: 100.00,
                              Y201303: 100.00,
                              Y201304: 100.00,
                              Y201305: 100.00,
                              Y201306: 100.00,
                              Y201307: 100.00,
                              Y201308: 100.00
                            }
                          ]
                        },
                        {
                          Cls: '도로운송',
                          Y201208: 105.02,
                          Y201209: 105.03,
                          Y201210: 105.81,
                          Y201211: 105.81,
                          Y201212: 105.21,
                          Y201301: 105.81,
                          Y201302: 106.02,
                          Y201303: 107.49,
                          Y201304: 107.82,
                          Y201305: 108.00,
                          Y201306: 107.78,
                          Y201307: 107.97,
                          Y201308: 107.97,
                          Items: [
                            {
                              Cls: '도로여객운송',
                              Y201208: 101.58,
                              Y201209: 101.58,
                              Y201210: 103.23,
                              Y201211: 103.23,
                              Y201212: 101.84,
                              Y201301: 103.31,
                              Y201302: 103.83,
                              Y201303: 107.43,
                              Y201304: 108.23,
                              Y201305: 108.66,
                              Y201306: 108.83,
                              Y201307: 109.28,
                              Y201308: 109.28
                            },
                            {
                              Cls: '도로화물운송',
                              Y201208: 107.82,
                              Y201209: 107.84,
                              Y201210: 107.96,
                              Y201211: 107.96,
                              Y201212: 107.96,
                              Y201301: 107.96,
                              Y201302: 107.96,
                              Y201303: 107.96,
                              Y201304: 107.96,
                              Y201305: 107.96,
                              Y201306: 107.47,
                              Y201307: 107.47,
                              Y201308: 107.47
                            }
                          ]
                        },
                        {
                          Cls: '택배',
                          Y201208: 96.57,
                          Y201209: 98.75,
                          Y201210: 105.54,
                          Y201211: 98.60,
                          Y201212: 97.99,
                          Y201301: 98.12,
                          Y201302: 98.32,
                          Y201303: 98.40,
                          Y201304: 98.32,
                          Y201305: 98.32,
                          Y201306: 98.30,
                          Y201307: 97.02,
                          Y201308: 97.02,
                          Items: [
                            {
                              Cls: '택배',
                              Y201208: 96.57,
                              Y201209: 98.75,
                              Y201210: 105.54,
                              Y201211: 98.60,
                              Y201212: 97.99,
                              Y201301: 98.12,
                              Y201302: 98.32,
                              Y201303: 98.40,
                              Y201304: 98.32,
                              Y201305: 98.32,
                              Y201306: 98.30,
                              Y201307: 97.02,
                              Y201308: 97.02
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '수상및항공운송',
                      Y201208: 100.23,
                      Y201209: 96.28,
                      Y201210: 96.87,
                      Y201211: 97.34,
                      Y201212: 96.61,
                      Y201301: 94.43,
                      Y201302: 92.97,
                      Y201303: 92.10,
                      Y201304: 91.15,
                      Y201305: 90.65,
                      Y201306: 91.56,
                      Y201307: 94.84,
                      Y201308: 95.81,
                      Items: [
                        {
                          Cls: '수상운송',
                          Y201208: 96.08,
                          Y201209: 93.94,
                          Y201210: 94.21,
                          Y201211: 95.39,
                          Y201212: 92.31,
                          Y201301: 87.96,
                          Y201302: 87.13,
                          Y201303: 88.59,
                          Y201304: 88.37,
                          Y201305: 88.70,
                          Y201306: 91.05,
                          Y201307: 91.20,
                          Y201308: 91.23,
                          Items: [
                            {
                              Cls: '연안및내륙수상운송',
                              Y201208: 117.93,
                              Y201209: 118.07,
                              Y201210: 118.07,
                              Y201211: 116.79,
                              Y201212: 116.79,
                              Y201301: 116.79,
                              Y201302: 116.24,
                              Y201303: 116.24,
                              Y201304: 116.30,
                              Y201305: 116.30,
                              Y201306: 116.30,
                              Y201307: 116.46,
                              Y201308: 116.59
                            },
                            {
                              Cls: '외항운송',
                              Y201208: 92.30,
                              Y201209: 89.62,
                              Y201210: 89.95,
                              Y201211: 91.69,
                              Y201212: 87.88,
                              Y201301: 82.06,
                              Y201302: 81.12,
                              Y201303: 83.07,
                              Y201304: 82.76,
                              Y201305: 83.20,
                              Y201306: 86.34,
                              Y201307: 86.49,
                              Y201308: 86.49
                            }
                          ]
                        },
                        {
                          Cls: '항공운송',
                          Y201208: 109.48,
                          Y201209: 101.76,
                          Y201210: 103.01,
                          Y201211: 102.03,
                          Y201212: 106.17,
                          Y201301: 107.06,
                          Y201302: 104.65,
                          Y201303: 100.35,
                          Y201304: 98.31,
                          Y201305: 96.57,
                          Y201306: 95.41,
                          Y201307: 103.39,
                          Y201308: 105.76,
                          Items: [
                            {
                              Cls: '항공운송',
                              Y201208: 109.48,
                              Y201209: 101.76,
                              Y201210: 103.01,
                              Y201211: 102.03,
                              Y201212: 106.17,
                              Y201301: 107.06,
                              Y201302: 104.65,
                              Y201303: 100.35,
                              Y201304: 98.31,
                              Y201305: 96.57,
                              Y201306: 95.41,
                              Y201307: 103.39,
                              Y201308: 105.76
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '운수관련서비스',
                      Y201208: 104.43,
                      Y201209: 104.58,
                      Y201210: 104.58,
                      Y201211: 104.80,
                      Y201212: 104.80,
                      Y201301: 104.93,
                      Y201302: 105.01,
                      Y201303: 104.86,
                      Y201304: 105.07,
                      Y201305: 105.10,
                      Y201306: 105.85,
                      Y201307: 105.80,
                      Y201308: 105.80,
                      Items: [
                        {
                          Cls: '운수보조서비스',
                          Y201208: 102.75,
                          Y201209: 102.75,
                          Y201210: 102.75,
                          Y201211: 102.75,
                          Y201212: 102.75,
                          Y201301: 102.98,
                          Y201302: 103.50,
                          Y201303: 103.25,
                          Y201304: 103.25,
                          Y201305: 103.28,
                          Y201306: 103.50,
                          Y201307: 103.41,
                          Y201308: 103.41,
                          Items: [
                            {
                              Cls: '육상운수보조서비스',
                              Y201208: 103.25,
                              Y201209: 103.25,
                              Y201210: 103.25,
                              Y201211: 103.25,
                              Y201212: 103.25,
                              Y201301: 103.34,
                              Y201302: 104.05,
                              Y201303: 104.05,
                              Y201304: 104.05,
                              Y201305: 104.09,
                              Y201306: 104.38,
                              Y201307: 104.25,
                              Y201308: 104.25
                            },
                            {
                              Cls: '수상운수보조서비스',
                              Y201208: 100.79,
                              Y201209: 100.79,
                              Y201210: 100.79,
                              Y201211: 100.79,
                              Y201212: 100.79,
                              Y201301: 102.79,
                              Y201302: 102.79,
                              Y201303: 99.50,
                              Y201304: 99.50,
                              Y201305: 99.50,
                              Y201306: 99.50,
                              Y201307: 99.50,
                              Y201308: 99.50
                            },
                            {
                              Cls: '항공운수보조서비스',
                              Y201208: 101.77,
                              Y201209: 101.77,
                              Y201210: 101.77,
                              Y201211: 101.77,
                              Y201212: 101.77,
                              Y201301: 101.77,
                              Y201302: 101.77,
                              Y201303: 101.77,
                              Y201304: 101.77,
                              Y201305: 101.77,
                              Y201306: 101.77,
                              Y201307: 101.77,
                              Y201308: 101.77
                            }
                          ]
                        },
                        {
                          Cls: '하역및보관',
                          Y201208: 107.27,
                          Y201209: 107.69,
                          Y201210: 107.69,
                          Y201211: 108.28,
                          Y201212: 108.28,
                          Y201301: 108.28,
                          Y201302: 107.73,
                          Y201303: 107.73,
                          Y201304: 108.23,
                          Y201305: 108.26,
                          Y201306: 109.75,
                          Y201307: 109.75,
                          Y201308: 109.75,
                          Items: [
                            {
                              Cls: '하역',
                              Y201208: 107.35,
                              Y201209: 107.35,
                              Y201210: 107.35,
                              Y201211: 107.35,
                              Y201212: 107.35,
                              Y201301: 107.35,
                              Y201302: 107.35,
                              Y201303: 107.35,
                              Y201304: 108.10,
                              Y201305: 108.10,
                              Y201306: 110.39,
                              Y201307: 110.39,
                              Y201308: 110.39
                            },
                            {
                              Cls: '보관및창고',
                              Y201208: 107.39,
                              Y201209: 108.49,
                              Y201210: 108.49,
                              Y201211: 110.04,
                              Y201212: 110.04,
                              Y201301: 110.04,
                              Y201302: 108.47,
                              Y201303: 108.47,
                              Y201304: 108.47,
                              Y201305: 108.59,
                              Y201306: 108.59,
                              Y201307: 108.59,
                              Y201308: 108.59
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '통신',
                  Y201208: 98.59,
                  Y201209: 98.63,
                  Y201210: 98.71,
                  Y201211: 98.71,
                  Y201212: 97.40,
                  Y201301: 96.99,
                  Y201302: 96.99,
                  Y201303: 96.99,
                  Y201304: 96.99,
                  Y201305: 96.99,
                  Y201306: 96.99,
                  Y201307: 96.99,
                  Y201308: 97.37,
                  Items: [
                    {
                      Cls: '통신',
                      Y201208: 98.59,
                      Y201209: 98.63,
                      Y201210: 98.71,
                      Y201211: 98.71,
                      Y201212: 97.40,
                      Y201301: 96.99,
                      Y201302: 96.99,
                      Y201303: 96.99,
                      Y201304: 96.99,
                      Y201305: 96.99,
                      Y201306: 96.99,
                      Y201307: 96.99,
                      Y201308: 97.37,
                      Items: [
                        {
                          Cls: '우편',
                          Y201208: 102.75,
                          Y201209: 102.75,
                          Y201210: 104.04,
                          Y201211: 104.04,
                          Y201212: 104.04,
                          Y201301: 104.04,
                          Y201302: 104.04,
                          Y201303: 104.04,
                          Y201304: 104.04,
                          Y201305: 104.04,
                          Y201306: 104.04,
                          Y201307: 104.04,
                          Y201308: 109.56,
                          Items: [
                            {
                              Cls: '우편',
                              Y201208: 102.75,
                              Y201209: 102.75,
                              Y201210: 104.04,
                              Y201211: 104.04,
                              Y201212: 104.04,
                              Y201301: 104.04,
                              Y201302: 104.04,
                              Y201303: 104.04,
                              Y201304: 104.04,
                              Y201305: 104.04,
                              Y201306: 104.04,
                              Y201307: 104.04,
                              Y201308: 109.56
                            }
                          ]
                        },
                        {
                          Cls: '유ㆍ무선통신서비스',
                          Y201208: 98.11,
                          Y201209: 98.11,
                          Y201210: 98.11,
                          Y201211: 98.11,
                          Y201212: 96.32,
                          Y201301: 95.76,
                          Y201302: 95.76,
                          Y201303: 95.76,
                          Y201304: 95.76,
                          Y201305: 95.76,
                          Y201306: 95.76,
                          Y201307: 95.76,
                          Y201308: 95.76,
                          Items: [
                            {
                              Cls: '유선통신서비스',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 100.00,
                              Y201301: 100.00,
                              Y201302: 100.00,
                              Y201303: 100.00,
                              Y201304: 100.00,
                              Y201305: 100.00,
                              Y201306: 100.00,
                              Y201307: 100.00,
                              Y201308: 100.00
                            },
                            {
                              Cls: '무선통신서비스',
                              Y201208: 97.28,
                              Y201209: 97.28,
                              Y201210: 97.28,
                              Y201211: 97.28,
                              Y201212: 94.79,
                              Y201301: 94.04,
                              Y201302: 94.04,
                              Y201303: 94.04,
                              Y201304: 94.04,
                              Y201305: 94.04,
                              Y201306: 94.04,
                              Y201307: 94.04,
                              Y201308: 94.04
                            }
                          ]
                        },
                        {
                          Cls: '기타통신서비스',
                          Y201208: 98.81,
                          Y201209: 98.97,
                          Y201210: 98.97,
                          Y201211: 98.97,
                          Y201212: 98.97,
                          Y201301: 98.97,
                          Y201302: 98.97,
                          Y201303: 98.97,
                          Y201304: 98.97,
                          Y201305: 98.97,
                          Y201306: 98.97,
                          Y201307: 98.97,
                          Y201308: 98.97,
                          Items: [
                            {
                              Cls: '초고속망서비스',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 100.00,
                              Y201301: 100.00,
                              Y201302: 100.00,
                              Y201303: 100.00,
                              Y201304: 100.00,
                              Y201305: 100.00,
                              Y201306: 100.00,
                              Y201307: 100.00,
                              Y201308: 100.00
                            },
                            {
                              Cls: '기타전기통신서비스',
                              Y201208: 97.76,
                              Y201209: 98.06,
                              Y201210: 98.06,
                              Y201211: 98.06,
                              Y201212: 98.06,
                              Y201301: 98.06,
                              Y201302: 98.06,
                              Y201303: 98.06,
                              Y201304: 98.06,
                              Y201305: 98.06,
                              Y201306: 98.06,
                              Y201307: 98.06,
                              Y201308: 98.06
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '정보,출판및영상서비스',
                  Y201208: 101.07,
                  Y201209: 101.07,
                  Y201210: 101.07,
                  Y201211: 101.07,
                  Y201212: 101.07,
                  Y201301: 101.55,
                  Y201302: 101.59,
                  Y201303: 101.46,
                  Y201304: 101.46,
                  Y201305: 101.46,
                  Y201306: 101.47,
                  Y201307: 101.56,
                  Y201308: 101.57,
                  Items: [
                    {
                      Cls: '정보서비스 및 소프트웨어 개발공급',
                      Y201208: 100.94,
                      Y201209: 100.94,
                      Y201210: 100.94,
                      Y201211: 100.94,
                      Y201212: 100.94,
                      Y201301: 101.61,
                      Y201302: 101.61,
                      Y201303: 101.29,
                      Y201304: 101.29,
                      Y201305: 101.29,
                      Y201306: 101.29,
                      Y201307: 101.29,
                      Y201308: 101.29,
                      Items: [
                        {
                          Cls: '정보서비스',
                          Y201208: 100.00,
                          Y201209: 100.00,
                          Y201210: 100.00,
                          Y201211: 100.00,
                          Y201212: 100.00,
                          Y201301: 117.06,
                          Y201302: 117.06,
                          Y201303: 109.05,
                          Y201304: 109.05,
                          Y201305: 109.05,
                          Y201306: 109.05,
                          Y201307: 109.05,
                          Y201308: 109.05,
                          Items: [
                            {
                              Cls: '정보서비스',
                              Y201208: 100.00,
                              Y201209: 100.00,
                              Y201210: 100.00,
                              Y201211: 100.00,
                              Y201212: 100.00,
                              Y201301: 117.06,
                              Y201302: 117.06,
                              Y201303: 109.05,
                              Y201304: 109.05,
                              Y201305: 109.05,
                              Y201306: 109.05,
                              Y201307: 109.05,
                              Y201308: 109.05
                            }
                          ]
                        },
                        {
                          Cls: '소프트웨어개발공급',
                          Y201208: 100.97,
                          Y201209: 100.97,
                          Y201210: 100.97,
                          Y201211: 100.97,
                          Y201212: 100.97,
                          Y201301: 100.97,
                          Y201302: 100.97,
                          Y201303: 100.97,
                          Y201304: 100.97,
                          Y201305: 100.97,
                          Y201306: 100.97,
                          Y201307: 100.97,
                          Y201308: 100.97,
                          Items: [
                            {
                              Cls: '소프트웨어개발공급',
                              Y201208: 100.97,
                              Y201209: 100.97,
                              Y201210: 100.97,
                              Y201211: 100.97,
                              Y201212: 100.97,
                              Y201301: 100.97,
                              Y201302: 100.97,
                              Y201303: 100.97,
                              Y201304: 100.97,
                              Y201305: 100.97,
                              Y201306: 100.97,
                              Y201307: 100.97,
                              Y201308: 100.97
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '출판및영상 오디오물제작배급',
                      Y201208: 101.45,
                      Y201209: 101.45,
                      Y201210: 101.45,
                      Y201211: 101.45,
                      Y201212: 101.45,
                      Y201301: 101.45,
                      Y201302: 101.59,
                      Y201303: 101.96,
                      Y201304: 101.96,
                      Y201305: 101.96,
                      Y201306: 101.98,
                      Y201307: 102.25,
                      Y201308: 102.29,
                      Items: [
                        {
                          Cls: '출판및영상 오디오물제작배급',
                          Y201208: 101.45,
                          Y201209: 101.45,
                          Y201210: 101.45,
                          Y201211: 101.45,
                          Y201212: 101.45,
                          Y201301: 101.45,
                          Y201302: 101.59,
                          Y201303: 101.96,
                          Y201304: 101.96,
                          Y201305: 101.96,
                          Y201306: 101.98,
                          Y201307: 102.25,
                          Y201308: 102.29,
                          Items: [
                            {
                              Cls: '신문',
                              Y201208: 103.83,
                              Y201209: 103.83,
                              Y201210: 103.83,
                              Y201211: 103.83,
                              Y201212: 103.83,
                              Y201301: 103.83,
                              Y201302: 103.83,
                              Y201303: 103.83,
                              Y201304: 103.83,
                              Y201305: 103.83,
                              Y201306: 103.83,
                              Y201307: 103.83,
                              Y201308: 103.83
                            },
                            {
                              Cls: '출판',
                              Y201208: 101.05,
                              Y201209: 101.05,
                              Y201210: 101.05,
                              Y201211: 101.05,
                              Y201212: 101.05,
                              Y201301: 101.05,
                              Y201302: 101.05,
                              Y201303: 101.57,
                              Y201304: 101.57,
                              Y201305: 101.57,
                              Y201306: 101.57,
                              Y201307: 101.91,
                              Y201308: 101.91
                            },
                            {
                              Cls: '영화상영',
                              Y201208: 101.00,
                              Y201209: 101.00,
                              Y201210: 101.00,
                              Y201211: 101.00,
                              Y201212: 101.00,
                              Y201301: 101.00,
                              Y201302: 101.80,
                              Y201303: 101.90,
                              Y201304: 101.90,
                              Y201305: 101.90,
                              Y201306: 102.00,
                              Y201307: 102.30,
                              Y201308: 102.50
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '금융및보험',
                  Y201208: 98.89,
                  Y201209: 99.40,
                  Y201210: 99.07,
                  Y201211: 98.58,
                  Y201212: 99.14,
                  Y201301: 94.61,
                  Y201302: 94.64,
                  Y201303: 94.82,
                  Y201304: 94.03,
                  Y201305: 94.17,
                  Y201306: 93.32,
                  Y201307: 92.82,
                  Y201308: 93.04,
                  Items: [
                    {
                      Cls: '금융및보험',
                      Y201208: 98.89,
                      Y201209: 99.40,
                      Y201210: 99.07,
                      Y201211: 98.58,
                      Y201212: 99.14,
                      Y201301: 94.61,
                      Y201302: 94.64,
                      Y201303: 94.82,
                      Y201304: 94.03,
                      Y201305: 94.17,
                      Y201306: 93.32,
                      Y201307: 92.82,
                      Y201308: 93.04,
                      Items: [
                        {
                          Cls: '금융',
                          Y201208: 98.09,
                          Y201209: 98.87,
                          Y201210: 98.50,
                          Y201211: 97.86,
                          Y201212: 98.63,
                          Y201301: 92.53,
                          Y201302: 92.35,
                          Y201303: 92.55,
                          Y201304: 92.12,
                          Y201305: 92.41,
                          Y201306: 91.22,
                          Y201307: 91.08,
                          Y201308: 91.39,
                          Items: [
                            {
                              Cls: '예금취급기관',
                              Y201208: 84.82,
                              Y201209: 84.82,
                              Y201210: 84.82,
                              Y201211: 84.82,
                              Y201212: 84.82,
                              Y201301: 84.76,
                              Y201302: 84.76,
                              Y201303: 84.76,
                              Y201304: 84.76,
                              Y201305: 84.76,
                              Y201306: 84.76,
                              Y201307: 84.76,
                              Y201308: 84.76
                            },
                            {
                              Cls: '금융투자기관',
                              Y201208: 89.07,
                              Y201209: 89.16,
                              Y201210: 88.86,
                              Y201211: 88.58,
                              Y201212: 87.86,
                              Y201301: 87.52,
                              Y201302: 86.18,
                              Y201303: 86.21,
                              Y201304: 86.79,
                              Y201305: 85.58,
                              Y201306: 84.75,
                              Y201307: 84.56,
                              Y201308: 84.71
                            },
                            {
                              Cls: '기타금융중개기관',
                              Y201208: 102.97,
                              Y201209: 104.04,
                              Y201210: 103.58,
                              Y201211: 102.72,
                              Y201212: 103.96,
                              Y201301: 95.91,
                              Y201302: 95.86,
                              Y201303: 96.14,
                              Y201304: 95.47,
                              Y201305: 96.04,
                              Y201306: 94.58,
                              Y201307: 94.43,
                              Y201308: 94.81
                            }
                          ]
                        },
                        {
                          Cls: '보험',
                          Y201208: 100.34,
                          Y201209: 100.25,
                          Y201210: 100.04,
                          Y201211: 99.88,
                          Y201212: 99.96,
                          Y201301: 99.78,
                          Y201302: 100.40,
                          Y201303: 100.51,
                          Y201304: 98.77,
                          Y201305: 98.47,
                          Y201306: 98.54,
                          Y201307: 97.07,
                          Y201308: 97.05,
                          Items: [
                            {
                              Cls: '비생명보험',
                              Y201208: 100.34,
                              Y201209: 100.25,
                              Y201210: 100.04,
                              Y201211: 99.88,
                              Y201212: 99.96,
                              Y201301: 99.78,
                              Y201302: 100.40,
                              Y201303: 100.51,
                              Y201304: 98.77,
                              Y201305: 98.47,
                              Y201306: 98.54,
                              Y201307: 97.07,
                              Y201308: 97.05
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '부동산',
                  Y201208: 104.71,
                  Y201209: 104.78,
                  Y201210: 104.92,
                  Y201211: 105.09,
                  Y201212: 105.32,
                  Y201301: 105.56,
                  Y201302: 105.91,
                  Y201303: 106.06,
                  Y201304: 106.07,
                  Y201305: 106.26,
                  Y201306: 106.38,
                  Y201307: 106.53,
                  Y201308: 106.70,
                  Items: [
                    {
                      Cls: '부동산',
                      Y201208: 104.71,
                      Y201209: 104.78,
                      Y201210: 104.92,
                      Y201211: 105.09,
                      Y201212: 105.32,
                      Y201301: 105.56,
                      Y201302: 105.91,
                      Y201303: 106.06,
                      Y201304: 106.07,
                      Y201305: 106.26,
                      Y201306: 106.38,
                      Y201307: 106.53,
                      Y201308: 106.70,
                      Items: [
                        {
                          Cls: '부동산',
                          Y201208: 104.71,
                          Y201209: 104.78,
                          Y201210: 104.92,
                          Y201211: 105.09,
                          Y201212: 105.32,
                          Y201301: 105.56,
                          Y201302: 105.91,
                          Y201303: 106.06,
                          Y201304: 106.07,
                          Y201305: 106.26,
                          Y201306: 106.38,
                          Y201307: 106.53,
                          Y201308: 106.70,
                          Items: [
                            {
                              Cls: '주거서비스',
                              Y201208: 108.84,
                              Y201209: 109.01,
                              Y201210: 109.24,
                              Y201211: 109.57,
                              Y201212: 109.80,
                              Y201301: 110.00,
                              Y201302: 110.23,
                              Y201303: 110.50,
                              Y201304: 110.73,
                              Y201305: 111.00,
                              Y201306: 111.23,
                              Y201307: 111.39,
                              Y201308: 111.59
                            },
                            {
                              Cls: '비주거용건물임대',
                              Y201208: 101.83,
                              Y201209: 101.92,
                              Y201210: 101.97,
                              Y201211: 102.06,
                              Y201212: 102.16,
                              Y201301: 102.28,
                              Y201302: 102.42,
                              Y201303: 102.49,
                              Y201304: 102.35,
                              Y201305: 102.42,
                              Y201306: 102.54,
                              Y201307: 102.74,
                              Y201308: 102.89
                            },
                            {
                              Cls: '부동산관련서비스',
                              Y201208: 103.33,
                              Y201209: 102.99,
                              Y201210: 103.20,
                              Y201211: 103.12,
                              Y201212: 103.96,
                              Y201301: 104.94,
                              Y201302: 106.83,
                              Y201303: 106.86,
                              Y201304: 106.67,
                              Y201305: 107.25,
                              Y201306: 106.94,
                              Y201307: 106.80,
                              Y201308: 106.93
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '사업서비스',
                  Y201208: 104.89,
                  Y201209: 105.35,
                  Y201210: 105.27,
                  Y201211: 105.22,
                  Y201212: 105.13,
                  Y201301: 105.19,
                  Y201302: 105.28,
                  Y201303: 105.24,
                  Y201304: 105.25,
                  Y201305: 105.40,
                  Y201306: 105.40,
                  Y201307: 105.43,
                  Y201308: 105.53,
                  Items: [
                    {
                      Cls: '사업관련전문서비스',
                      Y201208: 105.40,
                      Y201209: 105.95,
                      Y201210: 105.85,
                      Y201211: 105.76,
                      Y201212: 105.63,
                      Y201301: 105.73,
                      Y201302: 105.83,
                      Y201303: 105.74,
                      Y201304: 105.67,
                      Y201305: 105.55,
                      Y201306: 105.48,
                      Y201307: 105.38,
                      Y201308: 105.42,
                      Items: [
                        {
                          Cls: '사업관련전문서비스',
                          Y201208: 100.25,
                          Y201209: 100.25,
                          Y201210: 100.25,
                          Y201211: 100.25,
                          Y201212: 100.25,
                          Y201301: 100.25,
                          Y201302: 100.25,
                          Y201303: 100.25,
                          Y201304: 100.33,
                          Y201305: 100.72,
                          Y201306: 100.72,
                          Y201307: 100.79,
                          Y201308: 100.79,
                          Items: [
                            {
                              Cls: '법무및회계서비스',
                              Y201208: 100.25,
                              Y201209: 100.25,
                              Y201210: 100.25,
                              Y201211: 100.25,
                              Y201212: 100.25,
                              Y201301: 100.25,
                              Y201302: 100.25,
                              Y201303: 100.25,
                              Y201304: 100.33,
                              Y201305: 100.72,
                              Y201306: 100.72,
                              Y201307: 100.79,
                              Y201308: 100.79
                            }
                          ]
                        },
                        {
                          Cls: '공학및과학서비스',
                          Y201208: 108.09,
                          Y201209: 108.95,
                          Y201210: 108.79,
                          Y201211: 108.67,
                          Y201212: 108.46,
                          Y201301: 108.61,
                          Y201302: 108.79,
                          Y201303: 108.63,
                          Y201304: 108.43,
                          Y201305: 108.12,
                          Y201306: 108.03,
                          Y201307: 107.83,
                          Y201308: 107.91,
                          Items: [
                            {
                              Cls: '건축?토목관련서비스',
                              Y201208: 108.80,
                              Y201209: 109.75,
                              Y201210: 109.58,
                              Y201211: 109.45,
                              Y201212: 109.22,
                              Y201301: 109.20,
                              Y201302: 109.39,
                              Y201303: 109.23,
                              Y201304: 109.00,
                              Y201305: 108.66,
                              Y201306: 108.55,
                              Y201307: 108.35,
                              Y201308: 108.42
                            },
                            {
                              Cls: '과학기술서비스',
                              Y201208: 101.33,
                              Y201209: 101.33,
                              Y201210: 101.33,
                              Y201211: 101.33,
                              Y201212: 101.33,
                              Y201301: 103.18,
                              Y201302: 103.18,
                              Y201303: 103.18,
                              Y201304: 103.18,
                              Y201305: 103.18,
                              Y201306: 103.18,
                              Y201307: 103.18,
                              Y201308: 103.18
                            }
                          ]
                        },
                        {
                          Cls: '광고',
                          Y201208: 100.69,
                          Y201209: 100.69,
                          Y201210: 100.69,
                          Y201211: 100.67,
                          Y201212: 100.67,
                          Y201301: 100.67,
                          Y201302: 100.67,
                          Y201303: 100.66,
                          Y201304: 100.90,
                          Y201305: 100.90,
                          Y201306: 100.90,
                          Y201307: 100.90,
                          Y201308: 100.90,
                          Items: [
                            {
                              Cls: '광고',
                              Y201208: 100.69,
                              Y201209: 100.69,
                              Y201210: 100.69,
                              Y201211: 100.67,
                              Y201212: 100.67,
                              Y201301: 100.67,
                              Y201302: 100.67,
                              Y201303: 100.66,
                              Y201304: 100.90,
                              Y201305: 100.90,
                              Y201306: 100.90,
                              Y201307: 100.90,
                              Y201308: 100.90
                            }
                          ]
                        }
                      ]
                    },
                    {
                      Cls: '사업지원서비스',
                      Y201208: 104.12,
                      Y201209: 104.47,
                      Y201210: 104.43,
                      Y201211: 104.40,
                      Y201212: 104.37,
                      Y201301: 104.40,
                      Y201302: 104.45,
                      Y201303: 104.46,
                      Y201304: 104.56,
                      Y201305: 105.06,
                      Y201306: 105.15,
                      Y201307: 105.34,
                      Y201308: 105.51,
                      Items: [
                        {
                          Cls: '사업지원서비스',
                          Y201208: 104.12,
                          Y201209: 104.47,
                          Y201210: 104.43,
                          Y201211: 104.40,
                          Y201212: 104.37,
                          Y201301: 104.40,
                          Y201302: 104.45,
                          Y201303: 104.46,
                          Y201304: 104.56,
                          Y201305: 105.06,
                          Y201306: 105.15,
                          Y201307: 105.34,
                          Y201308: 105.51,
                          Items: [
                            {
                              Cls: '컴퓨터관리서비스',
                              Y201208: 100.61,
                              Y201209: 100.61,
                              Y201210: 100.61,
                              Y201211: 100.61,
                              Y201212: 100.61,
                              Y201301: 100.61,
                              Y201302: 100.61,
                              Y201303: 100.61,
                              Y201304: 100.61,
                              Y201305: 100.61,
                              Y201306: 100.61,
                              Y201307: 100.61,
                              Y201308: 100.61
                            },
                            {
                              Cls: '기계장비및용품임대',
                              Y201208: 100.38,
                              Y201209: 102.77,
                              Y201210: 102.52,
                              Y201211: 102.28,
                              Y201212: 102.11,
                              Y201301: 102.30,
                              Y201302: 102.67,
                              Y201303: 102.78,
                              Y201304: 103.48,
                              Y201305: 103.18,
                              Y201306: 103.82,
                              Y201307: 104.89,
                              Y201308: 106.06
                            },
                            {
                              Cls: '청소소독및시설유지',
                              Y201208: 111.33,
                              Y201209: 111.33,
                              Y201210: 111.33,
                              Y201211: 111.33,
                              Y201212: 111.33,
                              Y201301: 111.33,
                              Y201302: 111.33,
                              Y201303: 111.33,
                              Y201304: 111.33,
                              Y201305: 113.68,
                              Y201306: 113.68,
                              Y201307: 113.68,
                              Y201308: 113.68
                            },
                            {
                              Cls: '인력공급및알선',
                              Y201208: 103.07,
                              Y201209: 103.07,
                              Y201210: 103.07,
                              Y201211: 103.07,
                              Y201212: 103.07,
                              Y201301: 103.07,
                              Y201302: 103.07,
                              Y201303: 103.07,
                              Y201304: 103.07,
                              Y201305: 103.07,
                              Y201306: 103.07,
                              Y201307: 103.23,
                              Y201308: 103.23
                            },
                            {
                              Cls: '기타사업지원서비스',
                              Y201208: 102.57,
                              Y201209: 102.57,
                              Y201210: 102.57,
                              Y201211: 102.57,
                              Y201212: 102.57,
                              Y201301: 102.57,
                              Y201302: 102.57,
                              Y201303: 102.57,
                              Y201304: 102.57,
                              Y201305: 102.57,
                              Y201306: 102.57,
                              Y201307: 102.57,
                              Y201308: 102.57
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '위생및자원재활용서비스',
                  Y201208: 109.05,
                  Y201209: 109.05,
                  Y201210: 109.05,
                  Y201211: 109.02,
                  Y201212: 109.02,
                  Y201301: 111.33,
                  Y201302: 111.33,
                  Y201303: 111.33,
                  Y201304: 111.76,
                  Y201305: 111.76,
                  Y201306: 111.82,
                  Y201307: 112.44,
                  Y201308: 112.60,
                  Items: [
                    {
                      Cls: '위생서비스',
                      Y201208: 109.05,
                      Y201209: 109.05,
                      Y201210: 109.05,
                      Y201211: 109.02,
                      Y201212: 109.02,
                      Y201301: 111.33,
                      Y201302: 111.33,
                      Y201303: 111.33,
                      Y201304: 111.76,
                      Y201305: 111.76,
                      Y201306: 111.82,
                      Y201307: 112.44,
                      Y201308: 112.60,
                      Items: [
                        {
                          Cls: '위생서비스',
                          Y201208: 109.05,
                          Y201209: 109.05,
                          Y201210: 109.05,
                          Y201211: 109.02,
                          Y201212: 109.02,
                          Y201301: 111.33,
                          Y201302: 111.33,
                          Y201303: 111.33,
                          Y201304: 111.76,
                          Y201305: 111.76,
                          Y201306: 111.82,
                          Y201307: 112.44,
                          Y201308: 112.60,
                          Items: [
                            {
                              Cls: '하수,폐수및분뇨처리',
                              Y201208: 119.32,
                              Y201209: 119.32,
                              Y201210: 119.32,
                              Y201211: 119.24,
                              Y201212: 119.24,
                              Y201301: 124.61,
                              Y201302: 124.61,
                              Y201303: 124.61,
                              Y201304: 125.60,
                              Y201305: 125.60,
                              Y201306: 125.75,
                              Y201307: 126.00,
                              Y201308: 126.38
                            },
                            {
                              Cls: '폐기물수집,운반및처리',
                              Y201208: 103.44,
                              Y201209: 103.44,
                              Y201210: 103.44,
                              Y201211: 103.44,
                              Y201212: 103.44,
                              Y201301: 103.44,
                              Y201302: 103.44,
                              Y201303: 103.44,
                              Y201304: 103.44,
                              Y201305: 103.44,
                              Y201306: 103.44,
                              Y201307: 104.35,
                              Y201308: 104.35
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '교육서비스',
                  Y201208: 109.11,
                  Y201209: 109.29,
                  Y201210: 109.39,
                  Y201211: 109.54,
                  Y201212: 109.64,
                  Y201301: 110.58,
                  Y201302: 111.11,
                  Y201303: 111.77,
                  Y201304: 111.88,
                  Y201305: 112.04,
                  Y201306: 112.18,
                  Y201307: 112.21,
                  Y201308: 112.29,
                  Items: [
                    {
                      Cls: '교육서비스',
                      Y201208: 109.11,
                      Y201209: 109.29,
                      Y201210: 109.39,
                      Y201211: 109.54,
                      Y201212: 109.64,
                      Y201301: 110.58,
                      Y201302: 111.11,
                      Y201303: 111.77,
                      Y201304: 111.88,
                      Y201305: 112.04,
                      Y201306: 112.18,
                      Y201307: 112.21,
                      Y201308: 112.29,
                      Items: [
                        {
                          Cls: '교육기관',
                          Y201208: 109.11,
                          Y201209: 109.29,
                          Y201210: 109.39,
                          Y201211: 109.54,
                          Y201212: 109.64,
                          Y201301: 110.58,
                          Y201302: 111.11,
                          Y201303: 111.77,
                          Y201304: 111.88,
                          Y201305: 112.04,
                          Y201306: 112.18,
                          Y201307: 112.21,
                          Y201308: 112.29,
                          Items: [
                            {
                              Cls: '교육기관(산업)',
                              Y201208: 109.11,
                              Y201209: 109.29,
                              Y201210: 109.39,
                              Y201211: 109.54,
                              Y201212: 109.64,
                              Y201301: 110.58,
                              Y201302: 111.11,
                              Y201303: 111.77,
                              Y201304: 111.88,
                              Y201305: 112.04,
                              Y201306: 112.18,
                              Y201307: 112.21,
                              Y201308: 112.29
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '문화및오락서비스',
                  Y201208: 103.56,
                  Y201209: 103.16,
                  Y201210: 103.24,
                  Y201211: 103.42,
                  Y201212: 103.58,
                  Y201301: 103.99,
                  Y201302: 104.06,
                  Y201303: 103.73,
                  Y201304: 104.17,
                  Y201305: 104.40,
                  Y201306: 104.39,
                  Y201307: 105.38,
                  Y201308: 105.23,
                  Items: [
                    {
                      Cls: '문화및오락서비스',
                      Y201208: 103.56,
                      Y201209: 103.16,
                      Y201210: 103.24,
                      Y201211: 103.42,
                      Y201212: 103.58,
                      Y201301: 103.99,
                      Y201302: 104.06,
                      Y201303: 103.73,
                      Y201304: 104.17,
                      Y201305: 104.40,
                      Y201306: 104.39,
                      Y201307: 105.38,
                      Y201308: 105.23,
                      Items: [
                        {
                          Cls: '스포츠및오락서비스',
                          Y201208: 103.56,
                          Y201209: 103.16,
                          Y201210: 103.24,
                          Y201211: 103.42,
                          Y201212: 103.58,
                          Y201301: 103.99,
                          Y201302: 104.06,
                          Y201303: 103.73,
                          Y201304: 104.17,
                          Y201305: 104.40,
                          Y201306: 104.39,
                          Y201307: 105.38,
                          Y201308: 105.23,
                          Items: [
                            {
                              Cls: '스포츠서비스',
                              Y201208: 103.29,
                              Y201209: 103.50,
                              Y201210: 103.59,
                              Y201211: 103.81,
                              Y201212: 104.05,
                              Y201301: 103.96,
                              Y201302: 103.97,
                              Y201303: 104.46,
                              Y201304: 104.46,
                              Y201305: 104.54,
                              Y201306: 104.53,
                              Y201307: 104.37,
                              Y201308: 104.17
                            },
                            {
                              Cls: '오락서비스',
                              Y201208: 104.39,
                              Y201209: 102.45,
                              Y201210: 102.54,
                              Y201211: 102.58,
                              Y201212: 102.59,
                              Y201301: 104.30,
                              Y201302: 104.49,
                              Y201303: 102.07,
                              Y201304: 103.65,
                              Y201305: 104.24,
                              Y201306: 104.24,
                              Y201307: 108.17,
                              Y201308: 108.14
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  Cls: '기타개인서비스',
                  Y201208: 107.13,
                  Y201209: 107.22,
                  Y201210: 107.58,
                  Y201211: 107.66,
                  Y201212: 107.80,
                  Y201301: 108.13,
                  Y201302: 108.37,
                  Y201303: 108.53,
                  Y201304: 108.67,
                  Y201305: 108.76,
                  Y201306: 108.75,
                  Y201307: 108.67,
                  Y201308: 108.80,
                  Items: [
                    {
                      Cls: '기타개인서비스',
                      Y201208: 107.13,
                      Y201209: 107.22,
                      Y201210: 107.58,
                      Y201211: 107.66,
                      Y201212: 107.80,
                      Y201301: 108.13,
                      Y201302: 108.37,
                      Y201303: 108.53,
                      Y201304: 108.67,
                      Y201305: 108.76,
                      Y201306: 108.75,
                      Y201307: 108.67,
                      Y201308: 108.80,
                      Items: [
                        {
                          Cls: '수리서비스',
                          Y201208: 103.77,
                          Y201209: 103.83,
                          Y201210: 104.33,
                          Y201211: 104.42,
                          Y201212: 104.62,
                          Y201301: 104.68,
                          Y201302: 104.79,
                          Y201303: 104.71,
                          Y201304: 104.80,
                          Y201305: 104.83,
                          Y201306: 104.80,
                          Y201307: 104.70,
                          Y201308: 104.70,
                          Items: [
                            {
                              Cls: '자동차수리서비스',
                              Y201208: 104.00,
                              Y201209: 104.07,
                              Y201210: 104.09,
                              Y201211: 104.09,
                              Y201212: 104.33,
                              Y201301: 104.39,
                              Y201302: 104.52,
                              Y201303: 104.41,
                              Y201304: 104.48,
                              Y201305: 104.50,
                              Y201306: 104.46,
                              Y201307: 104.43,
                              Y201308: 104.43
                            },
                            {
                              Cls: '개인및가정용품수리서비스',
                              Y201208: 102.99,
                              Y201209: 102.99,
                              Y201210: 105.35,
                              Y201211: 105.76,
                              Y201212: 105.82,
                              Y201301: 105.87,
                              Y201302: 105.93,
                              Y201303: 105.95,
                              Y201304: 106.12,
                              Y201305: 106.19,
                              Y201306: 106.19,
                              Y201307: 105.83,
                              Y201308: 105.85
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
